define('jira/projects/sidebar/project-shortcuts/analytics', [
    "jira/ajs/dark-features",
    "jira/analytics",
    "jquery"
], function(DarkFeatures, analytics, jQuery) {
    "use strict";
    var shortcutLinkSelector = "a.project-shortcuts-group__link";
    var isWithIcons = DarkFeatures.isEnabled("com.atlassian.jira.projects.ProjectCentricNavigation.ProjectShortcutIcons");

    return {
        initialize: function(projectId) {
            this.projectId = projectId;
        },

        initShortcutClick: function (shortcutsElement, sidebarComponent) {
            var sidebar = sidebarComponent.getAUISidebar();
            var shortcuts = jQuery(shortcutsElement);
            var instance = this;

            shortcuts.on("click", shortcutLinkSelector, function (e) {
                var shortcutsList = shortcuts.find(shortcutLinkSelector);
                var clickedElement = jQuery(this);

                analytics.send({
                    name: "jira.projects.shortcut.clicked",
                    data: {
                        shortcutId: clickedElement.data("shortcutId"),
                        shortcutPosition: clickedElement.closest("li").index() + 1,
                        shortcutIconName: isWithIcons ? clickedElement.find(".aui-icon").data("projectShortcutsIconId") : "",
                        shortcutCount: shortcutsList.size(),
                        isWithIcons: isWithIcons,
                        isSidebarCollapsed: sidebar.isCollapsed(),
                        projectId: instance.projectId
                    }
                });
            });
        },

        initDialogActions: function (shortcutsList) {
            var instance = this;

            shortcutsList.on("childview:edit:open", function (view, model) {
                var index = model.collection.indexOf(model) + 1;
                analytics.send({
                    name: "jira.projects.shortcut.edit.dialog.opened",
                    data: {
                        isWithIcons: isWithIcons,
                        shortcutId: model.get("id"),
                        shortcutPosition: index,
                        shortcutCount: model.collection.size(),
                        projectId: instance.projectId
                    }
                });
            });
            shortcutsList.on("childview:edit:close", function (view, model, save) {
                var index = model.collection.indexOf(model) + 1;
                analytics.send({
                    name: "jira.projects.shortcut.edit.dialog.closed",
                    data: {
                        isWithIcons: isWithIcons,
                        isSave: save,
                        shortcutId: model.get("id"),
                        shortcutPosition: index,
                        shortcutCount: model.collection.size(),
                        projectId: instance.projectId
                    }
                });
            });

            shortcutsList.on("add:open", function () {
                analytics.send({
                    name: "jira.projects.shortcut.add.dialog.opened",
                    data: {
                        isWithIcons: isWithIcons,
                        projectId: instance.projectId
                    }
                });
            });
            shortcutsList.on("add:close", function (save) {
                analytics.send({
                    name: "jira.projects.shortcut.add.dialog.closed",
                    data: {
                        isWithIcons: isWithIcons,
                        isSave: save,
                        projectId: instance.projectId
                    }
                });
            });
        },

        iconChanged: function (model, iconName, oldIconName) {
            analytics.send({
                name: "jira.projects.shortcut.icon.changed",
                data: {
                    iconName: iconName,
                    oldIconName: oldIconName,
                    shortcutId: model.isNew() ? "" : model.get("id"),
                    isNew: model.isNew(),
                    cid: model.cid,
                    projectId: this.projectId
                }
            });
        },

        iconChangeConfirmed: function (model, iconName) {
            analytics.send({
                name: "jira.projects.shortcut.icon.confirmed",
                data: {
                    oldIconName: model.get("icon"),
                    iconName: iconName,
                    shortcutId: model.isNew() ? "" : model.get("id"),
                    isNew: model.isNew(),
                    cid: model.cid,
                    projectId: this.projectId
                }
            });
        },

        iconPickerOpened: function (model) {
            analytics.send({
                name: "jira.projects.shortcut.icon.picker.opened",
                data: {
                    shortcutId: model.isNew() ? "" : model.get("id"),
                    isNew: model.isNew(),
                    cid: model.cid,
                    projectId: this.projectId
                }
            });
        },

        iconPickerClosed: function (model, save) {
            analytics.send({
                name: "jira.projects.shortcut.icon.picker.closed",
                data: {
                    shortcutId: model.isNew() ? "" : model.get("id"),
                    isNew: model.isNew(),
                    cid: model.cid,
                    isSave: save,
                    projectId: this.projectId
                }
            });
        }
    };
});

AJS.namespace('JIRA.Projects.Sidebar.ProjectShortcuts.Analytics', null, require('jira/projects/sidebar/project-shortcuts/analytics'));
