define('jira/projects/sidebar/project-shortcuts/entities/shortcut', ["jira/util/formatter", "jira/util/logger", "backbone", "wrm/context-path"], function(formatter, logger, Backbone, wrmContextPath) {
    "use strict";

    function failedResponseToData(response) {
        var data;
        try {
            data = JSON.parse(response.responseText);
        } catch (e) {
            data = {
                message: formatter.I18n.getText('project.shortcuts.communication.error')
            };
        }

        return data;
    }

    return Backbone.Model.extend({
        defaults: {
            url: "",
            name: "",
            icon: ""
        },
        initialize: function (data, options) {
            if (!options || !options.projectKey) {
                throw "Project key is required";
            }
            this.projectKey = options.projectKey;
        },
        urlRoot: function urlRoot() {
            return wrmContextPath() + '/rest/projects/1.0/project/' + encodeURIComponent(this.projectKey) + '/shortcut'
        },
        clear: function clear() {
            this.unset("id");
            this.set("url", this.defaults.url);
            this.set("name", this.defaults.name);
            this.set("icon", this.defaults.icon);
        },

        save: function () {
            if (this.saving == true) {
                return;
            }
            this.saving = true;
            var model = this;
            model.trigger("save:start");
            var method = this.isNew() ? "create" : "update";
            this.sync(method, model)
                .always(function requestFinished() {
                    model.saving = false;
                    model.trigger("save:finish");
                })
                .done(function requestDone(savedModel) {
                    model.set(savedModel, {silent: true});
                    logger.trace("jira.projects.shortcuts." + method + ".success");
                    model.trigger("save:success");
                })
                .fail(function requestFailed(response) {
                    var data = failedResponseToData(response);
                    logger.trace("jira.projects.shortcuts." + method + ".fail");
                    model.trigger("save:failure", data);
                });
        },
        destroy: function () {
            if (this.saving == true) {
                return;
            }
            this.saving = true;
            var model = this;
            model.trigger("remove:start");
            var result = Backbone.Model.prototype.destroy.apply(this, arguments);
            result
                .always(function () {
                    model.saving = false;
                    model.trigger("remove:finish");
                })
                .done(function requestDone() {
                    model.trigger("remove:success");
                })
                .fail(function requestFailed(response) {
                    var data = failedResponseToData(response);
                    model.trigger("remove:failure", data);
                });
            return result;
        }

    });
});

AJS.namespace('JIRA.Projects.Sidebar.ProjectShortcuts.Entities.Shortcut', null, require('jira/projects/sidebar/project-shortcuts/entities/shortcut'));
