AJS.test.require(["com.atlassian.jira.jira-projects-plugin:sidebar-project-shortcuts"],function(){var a=require("wrm/context-path");var b=require("jira/projects/sidebar/project-shortcuts/entities/shortcut");module("jira/projects/sidebar/project-shortcuts/entities/shortcut",{setup:function(){this.model=new b({id:"1",url:"http://example.com/",name:"Example",icon:"jira"},{projectKey:"TEST"});this.server=sinon.fakeServer.create()},expectSuccessfulRequest:function(){this.server.respondWith(a()+"/rest/projects/1.0/project/TEST/shortcut/1",[200,{"Content-Type":"application/json"},'{ "id": 1, "url": "http://example.com/response", "name": "Example response", "icon": "Example icon" }'])},expectFailedRequest:function(){this.server.respondWith(a()+"/rest/projects/1.0/project/TEST/shortcut/1",[400,{"Content-Type":"application/json"},'{ "errors": { "url": "Invalid url", "name": "Invalid name", "icon": "Invalid icon" } }'])},teardown:function(){this.server.restore()}});test("Should throw when initialized without projectKey",function(){raises(function(){new b(undefined)},"Project key is required")});test("Should remove id and set url, name and icon to empty string on clear",function(){this.model.clear();equal(this.model.get("id"),undefined);equal(this.model.get("url"),"");equal(this.model.get("name"),"");equal(this.model.get("icon"),"")});test("Should create model when it has no id when saving",function(){var c=this.sandbox.spy(this.model,"sync");this.model.unset("id");this.server.respondWith(a()+"/rest/projects/1.0/project/TEST/shortcut",[200,{"Content-Type":"application/json"},'{ "id": 1, "url": "http://example.com/response", "name": "Example response", "icon": "Example icon"}']);this.model.save();this.server.respond();sinon.assert.calledWith(c,"create")});test("Should update model when it has id when saving",function(){var c=this.sandbox.spy(this.model,"sync");this.expectSuccessfulRequest();this.model.save();this.server.respond();sinon.assert.calledWith(c,"update")});test("Should trigger save:start event when save request is sent",function(){var c=this.sandbox.spy();this.model.on("save:start",c);this.expectSuccessfulRequest();this.model.save();this.server.respond();sinon.assert.calledOnce(c)});test("Should trigger save:finish and save:success event when save request is successful",function(){var c=this.sandbox.stub();var d=this.sandbox.stub();this.model.on("save:finish",c);this.model.on("save:success",d);this.expectSuccessfulRequest();this.model.save();this.server.respond();sinon.assert.calledOnce(c);sinon.assert.calledOnce(d);sinon.assert.callOrder(c,d)});test("Should trigger save:finish and save:failure event with error details when save request fails",function(){var d=this.sandbox.spy();var c=this.sandbox.spy();this.model.on("save:finish",d);this.model.on("save:failure",c);this.expectFailedRequest();this.model.save();this.server.respond();sinon.assert.calledOnce(d);sinon.assert.calledOnce(c);sinon.assert.calledWith(c,{errors:{url:"Invalid url",name:"Invalid name",icon:"Invalid icon"}});sinon.assert.callOrder(d,c)});test("Should not trigger another save/remove request when one is pending",function(){var c=this.sandbox.spy();this.model.on("save:finish",c);this.expectSuccessfulRequest();this.model.save();this.model.save();this.model.destroy();this.server.respond();sinon.assert.calledOnce(c);equal(this.server.requests.length,1)});test("Should trigger remove:start event when remove request is sent",function(){var c=this.sandbox.spy();this.model.on("remove:start",c);this.expectSuccessfulRequest();this.model.destroy();this.server.respond();sinon.assert.calledOnce(c)});test("Should trigger remove:finish and remove:success event when remove request is successful",function(){var c=this.sandbox.spy();var d=this.sandbox.spy();this.model.on("remove:finish",c);this.model.on("remove:success",d);this.expectSuccessfulRequest();this.model.destroy();this.server.respond();sinon.assert.calledOnce(c);sinon.assert.calledOnce(d);sinon.assert.callOrder(c,d)});test("Should trigger remove:finish and remove:failure event with error details when remove request fails",function(){var d=this.sandbox.spy();var c=this.sandbox.spy();this.model.on("remove:finish",d);this.model.on("remove:failure",c);this.expectFailedRequest();this.model.destroy();this.server.respond();sinon.assert.calledOnce(d);sinon.assert.calledOnce(c);sinon.assert.calledWith(c,{errors:{url:"Invalid url",name:"Invalid name",icon:"Invalid icon"}});sinon.assert.callOrder(d,c)})});