AJS.test.require(["com.atlassian.jira.jira-projects-plugin:sidebar-project-shortcuts"], function(){
    "use strict";

    var Backbone = require("backbone");

    module('jira/projects/sidebar/project-shortcuts/dialogs/delete', {
        setup: function () {
            this.context = AJS.test.mockableModuleContext();
            this.sandbox = sinon.sandbox.create();

            this.dialog = {
                show: sinon.stub(),
                hide: sinon.stub(),
                on: sinon.stub()
            };
            this.sandbox.stub(AJS, 'dialog2').returns(this.dialog);

            this.mockFlag = sinon.stub();
            this.context.mock("jira/flag", this.mockFlag);

            var PSDeleteDialog = this.context.require("jira/projects/sidebar/project-shortcuts/dialogs/delete");

            this.mockModel = new Backbone.Model();
            this.mockModel.save = sinon.stub();
            this.mockModel.set = sinon.stub();
            this.mockModel.destroy = sinon.stub();

            this.deleteDialog = new PSDeleteDialog({
                model: this.mockModel
            })
        },
        teardown: function () {
            this.sandbox.restore();
        }
    });

    test('Should show dialog when instantiated.', function () {
        sinon.assert.calledOnce(this.dialog.show);
    });

    test('Should disable all inputs and show spinner when delete starts.', function () {
        this.mockModel.trigger('remove:start');

        ok(this.deleteDialog.$(':input').is(':disabled'));
        ok(this.deleteDialog.ui.submit.hasClass('loading'));
        equal(this.deleteDialog.ui.submit.find('.spinner').length, 1);
    });

    test('Should enable all inputs and hide spinner when delete finishes.', function () {
        this.mockModel.trigger('remove:start');
        this.mockModel.trigger('remove:finish');

        ok(this.deleteDialog.$(':input').is(':enabled'));
        ok(!this.deleteDialog.$('#project-shortcuts-submit').hasClass('loading'));
        equal(this.deleteDialog.$('#project-shortcuts-submit .spinner').length, 0);
    });

    test('Should hide dialog when delete finishes.', function () {
        this.mockModel.trigger('remove:finish');
        sinon.assert.calledOnce(this.dialog.hide);
    });

    test('Should show global error flag when save fails.', function () {
        this.mockModel.trigger('remove:failure', {
            message: "auth error",
            errors: {}
        });

        sinon.assert.calledOnce(this.mockFlag);
        sinon.assert.calledWith(this.mockFlag, {
            type: "error",
            title: "project.shortcuts.dialog.error.general.delete",
            close: "auto",
            body: "auth error"
        });

        this.mockModel.trigger('remove:failure', {
            errorMessages: ["global error"]
        });

        sinon.assert.calledTwice(this.mockFlag);
        sinon.assert.calledWith(this.mockFlag, {
            type: "error",
            title: "project.shortcuts.dialog.error.general.delete",
            close: "auto",
            body: "global error"
        });
    });

    test('Should hide dialog on cancel.', function () {
        this.deleteDialog.ui.cancel.click();
        sinon.assert.calledOnce(this.dialog.hide);
    });

    test('Should destroy the model on form submit.', function () {
        this.deleteDialog.ui.submit.click();
        sinon.assert.calledOnce(this.mockModel.destroy);
    });
});

