require([
    "jira/jquery/deferred",
    'jira/skate',
    'wrm/require',
    'jquery',
    'jira/api/projects',
    'jira/util/logger',
    'jira/projects/sidebar/expansion-manager',
    'jira/ajs/dark-features'
], function(
    Deferred,
    skate,
    wrmRequire,
    jQuery,
    ProjectsAPI,
    logger,
    expansionManager,
    DarkFeatures
) {
    "use strict";

    var dclFired = false;
    var dclPromise = (function() {
        var deferred = new Deferred();
        jQuery(function() {
            deferred.resolve();
            dclFired = true;
        });
        return deferred.promise();
    })();

    var resourcesLoadedPromise = (function() {
        if (DarkFeatures.isEnabled('com.atlassian.jira.projects.sidebar.DEFER_RESOURCES')
                && !DarkFeatures.isEnabled('com.atlassian.jira.projects.sidebar.DEFER_RESOURCES_KILLSWITCH')) {
            var projectType = ProjectsAPI.getCurrentProjectType();

            var contexts = ['wrc!jira.project.sidebar'];
            if (projectType) {
                contexts.push('wrc!jira.project.sidebar.' + projectType);
            }
            return wrmRequire(contexts);
        }
        return new Deferred().resolve().promise();
    })();

    var sidebarInitialisedPromise = (function() {
        var deferred = new Deferred();
        document.addEventListener('sidebar:initialised', function (evt) {
            expansionManager(evt.detail);
            if (evt.target.classList.contains('projects-sidebar')) {
                deferred.resolve(evt);
            }
        });
        return deferred.promise();
    })();

    // make sure we never fire before DCL so the API is never initialised before that
    jQuery.when(sidebarInitialisedPromise, resourcesLoadedPromise, dclPromise).done(function (sidebarLoadedEvent) {
        var sidebar = sidebarLoadedEvent.target;
        var placeholder = sidebar.parentElement.querySelector('.sidebar-placeholder');
        if (placeholder) {
            sidebar.classList.add('fade-in');
            placeholder.addEventListener('animationend', function () {
                placeholder.parentNode.removeChild(placeholder);
            });
            placeholder.classList.add('fade-out')
        }
        sidebar.classList.remove('sidebar-pending');

        // Either after the WRM.require, or after the action has required the correct context,
        // this module should be available synchronously.
        var sidebarInitializer = require('jira/projects/sidebar/sidebar-initializer');
        sidebarInitializer.init(sidebarLoadedEvent.detail);
        logger.trace('jira.projects.sidebar.init', {dclFired: dclFired});
    });

    skate('aui-sidebar', {
        type: skate.type.CLASSNAME,
        attached: function (el) {
            var sidebar = AJS.sidebar(el);

            // TODO: once we drop IE support this should be rewritten to new CustomEvent('sidebar:initialised', ...) - tracked in NEXT-697
            var evt = document.createEvent('CustomEvent');
            evt.initCustomEvent('sidebar:initialised', true, false, sidebar);
            el.dispatchEvent(evt);
        }
    });

});
