define('jira/projects/sidebar/feature-discovery', [
    "jira/api/projects",
    "jira/api/projects/sidebar",
    "wrm/context-path",
    "underscore",
    "jquery"
], function(
    ProjectsAPI,
    SidebarAPI,
    wrmContextPath,
    _,
    jQuery
) {
    "use strict";

    function doBadgeRemoval(sidebarComponent, navigationItems) {
        _.each(navigationItems, function(navigationItemId) {
            var navigationItem = sidebarComponent.getItem(navigationItemId);
            if (navigationItem) {
                navigationItem.removeBadge();
            }
        });
    }

    function removeBadgesFor(navigationItems) {
        SidebarAPI.getSidebar().done(function(sidebarComponent) {
            doBadgeRemoval(sidebarComponent, navigationItems);
        });
    }

    return {
        /**
         * Updates the badges displayed next to the links on the sidebar.
         */
        updateBadges: function() {
            // a global board sidebar does not have a single project key to be used
            if (typeof ProjectsAPI.getCurrentProjectKey() === 'undefined') {
                return;
            }

            jQuery.ajax({
                url: wrmContextPath() + '/rest/projects/1.0/project/' + encodeURIComponent(ProjectsAPI.getCurrentProjectKey()) + '/badges',
                type: "PUT",
                contentType:"application/json"
            }).done(function(response) {
                removeBadgesFor(response.badgesToRemove || []);
            });
        }
    };
});

AJS.namespace('JIRA.Projects.Sidebar.FeatureDiscovery', null, require('jira/projects/sidebar/feature-discovery'));
