define('jira/projects/sidebar/expansion-manager', ['wrm/data'], function(wrmData) {
    "use strict";

    var STORAGE_KEY = 'jira-sidebar-collapsed';
    var isSidebarCollapsedByDefault = Boolean(wrmData.claim('sidebar-collapsed-by-default'));

    /**
     * @param {AJS.sidebar} sidebar An AUI sidebar.
     * @param {Storage} [storage=window.localStorage] The object in which to
     *     persist `sidebar`'s expansion state.
     */
    return function(sidebar, storage) {
        storage || (storage = window.localStorage);

        restoreCollapsedState();
        sidebar.on("expand-start", controlCollapsedStateOnResize);
        sidebar.on('expand-end collapse-end', persistCollapsedState);

        function controlCollapsedStateOnResize(event) {
            // prevent auto-expansion if user collapsed the sidebar before
            if (event.isResponsive && storage[STORAGE_KEY] === 'true') {
                event.preventDefault();
            }
        }

        function persistCollapsedState(event) {
            // remember the collapsed state only when it collapses on user's request
            // and viewport is not narrow at the moment
            if (!event.isResponsive && !sidebar.isViewportNarrow()) {
                storage[STORAGE_KEY] = sidebar.isCollapsed().toString();
            }
        }

        function restoreCollapsedState() {
            if (sidebar.reflow() && sidebar.isViewportNarrow()) {
                return;
            }

            if ((isSidebarCollapsedByDefault && storage[STORAGE_KEY] === undefined) || storage[STORAGE_KEY] === 'true') {
                sidebar.collapse();
            } else {
                sidebar.expand();
            }
        }
    };
});
