AJS.test.require(["com.atlassian.jira.jira-projects-plugin:sidebar-component"],function(){var b=require("jquery");var a=require("jira/util/browser");var c=require("jira/projects/sidebar/component/navigation-item");module("jira/projects/sidebar/component/navigation-item",{markup:'<li><a class="aui-nav-item" data-link-id="my-navigation-item"></a></li>',markupWithBadge:'<li><a class="aui-nav-item" data-link-id="my-navigation-item"><span class="aui-badge">badge</span></a></li>',buildNavigationItem:function(){return new c({el:this.markup})},buildSelectedNavigationItem:function(){var d=new c({el:this.markup});d.select();return d},buildNavigationItemWithLink:function(d){var e=this.buildNavigationItem();var f=this.stub(e.$el,"find");f.withArgs("a").returns(d);return e},buildNavigationItemWithBadge:function(){return new c({el:this.markupWithBadge})}});test("Extracts the link ID from the markup when constructed",function(){var d=this.buildNavigationItem();equal(d.id,"my-navigation-item")});test("When navigating on a item, it selects the item",function(){var d=this.buildNavigationItem();d.ui.link.attr("href","http://example.com");this.stub(a,"reloadViaWindowLocation");d.navigate();ok(d.isSelected())});test("When navigating on a item, it navigates to the link url",function(){var d=this.buildNavigationItem();d.ui.link.attr("href","http://example.com");var e=this.stub(a,"reloadViaWindowLocation");d.navigate();sinon.assert.calledOnce(e);sinon.assert.calledWith(e,"http://example.com")});test("When navigating on a item, it triggers the event 'before:select', 'select' and 'before:navigate', in that order",function(){var e=this.spy();var d=this.spy();var f=this.spy();var g=this.buildNavigationItem();g.on("before:navigate",f);g.on("before:select",e);g.on("select",d);this.stub(a,"reloadViaWindowLocation");g.navigate();sinon.assert.calledOnce(e);sinon.assert.calledOnce(d);sinon.assert.calledOnce(f);sinon.assert.callOrder(e,d,f)});test("When navigating on a item, it does not trigger the event 'select' if 'before:select' has been prevented",function(){var d=this.spy();var e=this.buildNavigationItem();e.on("before:select",function(f){f.preventDefault()});e.on("select",d);e.navigate();sinon.assert.notCalled(d)});test("When navigating on a item, it does not trigger the event 'before:navigate' if 'before:select' has been prevented",function(){var d=this.spy();var e=this.buildNavigationItem();e.on("before:select",function(f){f.preventDefault()});e.on("before:navigate",d);e.navigate();sinon.assert.notCalled(d)});test("When navigating on a item, it does not navigates if the 'before:select' event is prevented",function(){var d=this.buildNavigationItem();d.on("before:select",function(f){f.preventDefault()});d.ui.link.attr("href","http://example.com");var e=this.stub(a,"reloadViaWindowLocation");d.ui.link.click();sinon.assert.notCalled(e)});test("When navigating on a item, it does not navigates if the 'before:navigate' event is prevented",function(){var d=this.buildNavigationItem();d.on("before:navigate",function(f){f.preventDefault()});d.ui.link.attr("href","http://example.com");var e=this.stub(a,"reloadViaWindowLocation");d.navigate();sinon.assert.notCalled(e)});test("Selects the element",function(){var d=this.buildNavigationItem();d.select();ok(d.isSelected())});test("When selecting the item, it triggers the events 'before:select' and 'select', in that order",function(){var e=this.spy();var d=this.spy();var f=this.buildNavigationItem();f.on("before:select",e);f.on("select",d);f.select();sinon.assert.calledOnce(e);sinon.assert.calledOnce(d);sinon.assert.callOrder(e,d)});test("When selecting the item, it does not trigger the event 'select' if 'before:select' has been prevented",function(){var d=this.spy();var e=this.buildNavigationItem();e.on("before:select",function(f){f.preventDefault()});e.on("select",d);e.select();ok(!d.called)});test("Deselects the element",function(){var d=this.buildSelectedNavigationItem();d.deselect();ok(!d.isSelected())});test("When deselecting the item, it triggers the event 'before:deselect' and 'deselect', in that order",function(){var f=this.spy();var d=this.spy();var e=this.buildSelectedNavigationItem();e.on("before:deselect",f);e.on("deselect",d);e.deselect();sinon.assert.calledOnce(f);sinon.assert.calledOnce(d);sinon.assert.callOrder(f,d)});test("When deselecting the item, it does not trigger the event 'deselect' if 'before:deselect' has been prevented",function(){var d=this.spy();var e=this.buildSelectedNavigationItem();e.on("before:deselect",function(f){f.preventDefault()});e.on("deselect",d);e.deselect();sinon.assert.notCalled(d)});test("When deselecting the item, it does not trigger any event if the element was not initially selected",function(){var d=this.spy();var e=this.spy();var f=this.buildNavigationItem();f.on("before:deselect",e);f.on("deselect",d);f.deselect();sinon.assert.notCalled(d);sinon.assert.notCalled(e)});test("When deselecting the navigation item, it removes the focus from its link",function(){var d=b("<a>");this.spy(d,"blur");var e=this.buildNavigationItemWithLink(d);e.select();e.deselect();sinon.assert.calledOnce(d.blur)});test("When clicking the item's link, it triggers the events 'before:select', 'select' and 'before:navigate', in that order",function(){var e=this.spy();var d=this.spy();var f=this.spy();var g=this.buildNavigationItem();g.on("before:select",e);g.on("select",d);g.on("before:navigate",f);g.ui.link.click();sinon.assert.calledOnce(e);sinon.assert.calledOnce(d);sinon.assert.calledOnce(f);sinon.assert.callOrder(e,d,f)});test("When clicking the item's link, it navigates to the link url",function(){var d=this.buildNavigationItem();d.ui.link.attr("href","http://example.com");var e=this.stub(a,"reloadViaWindowLocation");d.ui.link.click();sinon.assert.calledOnce(e);sinon.assert.calledWith(e,"http://example.com")});test("When clicking the item's link with ctrl/cmd key, it uses standard browser's mechanism to navigate to the link url",function(){var g=this.buildNavigationItem();g.ui.link.attr("href","http://example.com");var d=this.stub(a,"reloadViaWindowLocation");var f=sinon.stub();g.on("before:navigate",f);g.on("before:select",f);g.on("select",f);var e=b.Event("click",{metaKey:true});g.ui.link.trigger(e);sinon.assert.notCalled(d);sinon.assert.notCalled(f)});test("When clicking the item's link with target=_blank attribute, it uses standard browser's mechanism to navigate to the link url",function(){var f=this.buildNavigationItem();f.ui.link.attr("href","http://example.com");f.ui.link.attr("target","_blank");var d=this.stub(a,"reloadViaWindowLocation");var e=sinon.stub();f.on("before:navigate",e);f.on("before:select",e);f.on("select",e);f.ui.link.trigger("click");sinon.assert.notCalled(d);sinon.assert.notCalled(e)});test("When clicking the item's link, it does not trigger the event 'select' if 'before:select' has been prevented",function(){var d=this.spy();var e=this.buildNavigationItem();e.on("before:select",function(f){f.preventDefault()});e.on("select",d);e.ui.link.click();sinon.assert.notCalled(d)});test("When clicking the item's link, it does not navigates if the 'before:select' event is prevented",function(){var d=this.buildNavigationItem();d.on("before:select",function(f){f.preventDefault()});d.ui.link.attr("href","http://example.com");var e=this.stub(a,"reloadViaWindowLocation");d.ui.link.click();sinon.assert.notCalled(e)});test("When clicking the item's link, it does not navigates if the 'before:navigate' event is prevented",function(){var d=this.buildNavigationItem();d.on("before:navigate",function(f){f.preventDefault()});d.ui.link.attr("href","http://example.com");var e=this.stub(a,"reloadViaWindowLocation");d.ui.link.click();sinon.assert.notCalled(e)});test("When removing the badge, the right DOM element is removed",function(){var d=this.buildNavigationItemWithBadge();d.removeBadge();equal(d.$el.find("a .aui-badge").length,0)});test("Returns the expected ID when the getId method is called",function(){var d=this.buildNavigationItem();equal(d.getId(),"my-navigation-item")});test("Returns itself if it is selected and the getSelectedNavigationItem method is called",function(){var e=this.buildSelectedNavigationItem();var d=e.getSelectedNavigationItem();ok(d===e)});test("Does not return itself if it isn't selected and the getSelectedNavigationItem method is called",function(){var e=this.buildNavigationItem();var d=e.getSelectedNavigationItem();ok(!(d===e))});test("Reports that it has a selected item when it is selected",function(){var d=this.buildSelectedNavigationItem();ok(d.hasASelectedItem())});test("Reports that it does not have a selected item when not selected",function(){var d=this.buildNavigationItem();ok(!d.hasASelectedItem())});test("When it is destroyed, events are unbound",function(){var d=this.buildNavigationItem();var e=sinon.stub();d.on("test-event",e);d.destroy();d.trigger("test-event");sinon.assert.notCalled(e)})});