AJS.test.require(["com.atlassian.jira.jira-projects-plugin:sidebar-component"],function(){var d=require("jquery");var b=require("underscore");var a=require("jira/util/logger");var c=require("jira/projects/sidebar/component/navigation-group");var f=require("jira/projects/sidebar/component/navigation-subgroup");var e=require("jira/projects/sidebar/component");module("jira/projects/sidebar/component",{setup:function(){this.context=AJS.test.mockableModuleContext();this.WRM={data:{claim:sinon.stub()}};this.navGroupModule=sinon.spy(c);this.navSubgroupModule=sinon.spy(f);this.context.mock("wrm/data",this.WRM.data);this.context.mock("jira/projects/sidebar/component/navigation-group",this.navGroupModule);this.context.mock("jira/projects/sidebar/component/navigation-subgroup",this.navSubgroupModule);this.context.mock("jira/util/logger",a)},sidebarWithGroups:function(){return this.buildSidebar(['<div class="aui-sidebar">','   <div class="aui-sidebar-group" data-id="sidebar-navigation-panel">',"      <ul>",'         <li><a class="aui-nav-item" data-link-id="my-navigation-item-1"></a></li>','         <li><a class="aui-nav-item"></a></li>','         <li><a class="aui-nav-item" data-link-id="my-navigation-item-3"></a></li>',"      </ul>","   </div>",'   <div class="aui-sidebar-group">',"      <ul>",'         <li><a class="aui-nav-item" data-link-id="my-navigation-item-1"></a></li>','         <li><a class="aui-nav-item"></a></li>','         <li><a class="aui-nav-item" data-link-id="my-navigation-item-3"></a></li>',"      </ul>","   </div>",'   <div class="aui-sidebar-group" data-id="my-navigation-group-3">',"      <ul>",'         <li><a class="aui-nav-item" data-link-id="my-navigation-item-1"></a></li>','         <li><a class="aui-nav-item"></a></li>','         <li><a class="aui-nav-item" data-link-id="my-navigation-item-3"></a></li>',"      </ul>","   </div>","</div>"].join(""))},sidebarWithSubgroups:function(){return this.buildSidebar(['<div class="aui-sidebar">','   <div class="aui-sidebar-group" data-id="sidebar-navigation-panel">',"      <ul>","         <li>","            <ul>",'               <li><a href="#"></a></li>',"            </ul>","         </li>",'         <li><a class="aui-nav-item" data-link-id="my-navigation-item-1"></a></li>',"      </ul>","   </div>","</div>"].join(""))},sidebarWithDuplicatedIds:function(){return this.buildSidebar(['<div class="aui-sidebar">','   <div class="aui-sidebar-group" data-id="duplicated">',"      <ul>",'         <li><a class="aui-nav-item" data-link-id="my-navigation-item-1"></a></li>','         <li><a class="aui-nav-item"></a></li>','         <li><a class="aui-nav-item" data-link-id="my-navigation-item-3"></a></li>',"      </ul>","   </div>",'   <div class="aui-sidebar-group" data-id="duplicated">',"      <ul>",'         <li><a class="aui-nav-item" data-link-id="my-navigation-item-1"></a></li>','         <li><a class="aui-nav-item"></a></li>','         <li><a class="aui-nav-item" data-link-id="my-navigation-item-3"></a></li>',"      </ul>","   </div>","</div>"].join(""))},sidebarWithScopeFilter:function(g){return this.buildSidebar(['<div class="aui-sidebar">','   <div class="scope-filter">','      <a class="scope-filter-trigger" data-scope-filter-id="'+g+'"></a>',"   </div>","</div>"].join(""))},sidebarWithoutScopeFilter:function(){return this.sidebarWithGroups()},sidebarWithReportsLink:function(g){g=g||"com.atlassian.jira.jira-projects-plugin:report-page";return this.buildSidebar(['<div class="aui-sidebar">','   <span class="aui-avatar-project"/>','   <div class="aui-sidebar-group" data-id="sidebar-navigation-panel">','      <ul class="aui-nav">',"         <li>",'            <a class="aui-nav-item" href="#" data-link-id="'+g+'">',"               <span>Reports</span>","            </a>","         </li>","      </ul>","   </div>","</div>"].join(""))},buildSidebar:function(g){var h=this.context.require("jira/projects/sidebar/component");return new h({el:g})},buildGroup:function(g){return new c({el:g})},triggerEventWithObject:function(i,h){var g={isPrevented:false,emitter:i,preventDefault:function(){this.isPrevented=true}};i.trigger(h,g);return g},getReportsLink:function(g){return g.$el.find(["a[data-link-id='com.atlassian.jira.jira-projects-plugin:report-page']","a[data-link-id='com.pyxis.greenhopper.jira:global-sidebar-report']"].join(",")).attr("href")},assertEventRetriggered:function(k,j,i){var h=this.spy();k.on(i,h);var g=this.triggerEventWithObject(j,i);sinon.assert.calledOnce(h);sinon.assert.calledWith(h,g)},assertEventPreventedAndRetriggered:function(l,k,j){var i=function(m){m.preventDefault()};k.on(j,i);var h=this.spy();l.on(j,h);var g=this.triggerEventWithObject(k,j);sinon.assert.calledOnce(h);sinon.assert.calledWith(h,g);ok(g.isPrevented);k.off(j,i)}});test("When constructed, it extracts the NavigationGroups",function(){this.sidebarWithGroups();ok(this.navGroupModule.calledThrice);ok(this.navGroupModule.calledWithNew)});test("When constructed, it logs a warning if the markup has duplicated IDs for groups",function(){var g=this.stub(a,"warn");this.sidebarWithDuplicatedIds();sinon.assert.calledOnce(g);sinon.assert.calledWith(g,'Duplicated IDs detected. There are more than one NavigationGroup with id data-id="duplicated"')});test("It deselect all groups",function(){var g=this.stub(c.prototype,"deselect");var h=this.sidebarWithGroups();h.deselectAllGroups();ok(g.calledThrice)});test("It can fetch the groups by the id",function(){var g=this.sidebarWithGroups();ok(g.getGroup("sidebar-navigation-panel") instanceof c);ok(g.getGroup("my-navigation-group-3") instanceof c)});test("It can fetch the groups by the index",function(){var g=this.sidebarWithGroups();ok(g.getGroupAt(0) instanceof c);ok(g.getGroupAt(1) instanceof c);ok(g.getGroupAt(2) instanceof c);ok(g.getGroup("sidebar-navigation-panel")===g.getGroupAt(0));ok(g.getGroup("my-navigation-group-3")===g.getGroupAt(2))});test("It can fetch the default group",function(){var g=this.sidebarWithGroups();ok(g.getDefaultGroup()===g.getGroup("sidebar-navigation-panel"));ok(g.getDefaultGroup()===g.getGroupAt(0))});test("It can fetch an item from the default group",function(){var g=this.sidebarWithGroups();ok(g.getItem("my-navigation-item-1")===g.getDefaultGroup().getItem("my-navigation-item-1"))});test("It can fetch a subgroup from the default group",function(){var g=this.sidebarWithSubgroups();ok(g.getDefaultGroup().getItemAt(0) instanceof f)});test("It can fetch items from a subgroup",function(){var g=this.sidebarWithSubgroups();ok(g.getDefaultGroup().getItemAt(0).getItemAt(0) instanceof e.NavigationItem)});test("It can replace an existing group",function(){var g=this.sidebarWithGroups();var h=this.buildGroup(['<div class="aui-sidebar-group" data-id="my-new-group">',"   <ul>",'      <li><a class="aui-nav-item" data-link-id="my-new-item"></a></li>',"   </ul>","</div>"].join(""));g.replaceGroup("sidebar-navigation-panel",h);ok(g.getGroup("sidebar-navigation-panel")===undefined);ok(g.getGroup("my-new-group")===h);ok(g.getGroup("my-new-group").getItem("my-new-item") instanceof e.NavigationItem)});test("When an item of a particular group is selected, it deselect all the items in all the groups",function(){var g=this.stub(c.prototype,"deselect");var h=this.sidebarWithGroups();h.getGroupAt(0).getItemAt(0).select();equal(g.callCount,4)});test("When a children triggers an event, the Component re-triggers it with the same EventObject",function(){var g=this.sidebarWithGroups();var h=g.getGroupAt(0);this.assertEventRetriggered(g,h,"before:select");this.assertEventRetriggered(g,h,"select");this.assertEventRetriggered(g,h,"before:deselect");this.assertEventRetriggered(g,h,"deselect");this.assertEventRetriggered(g,h,"before:navigate")});test("When a children triggers an event, the Component re-triggers it with the same EventObject, even if the original event was prevented",function(){var g=this.sidebarWithGroups();var h=g.getGroupAt(0);this.assertEventPreventedAndRetriggered(g,h,"before:select");this.assertEventPreventedAndRetriggered(g,h,"before:deselect");this.assertEventPreventedAndRetriggered(g,h,"before:navigate")});test("Can retrieve the identifier of the selected scope in the scope filter",function(){var h=this.sidebarWithScopeFilter("scope-filter-id");var g=h.getSelectedScopeFilterId();equal(g,"scope-filter-id")});test("Returns undefined as the identifier of the selected scope if there is no scope filter",function(){var h=this.sidebarWithoutScopeFilter();var g=h.getSelectedScopeFilterId();equal(g,undefined)});test("Sets the reports link correctly",function(){var g=this.sidebarWithReportsLink();g.setReportsItemLink("http://atlassian.com");equal(this.getReportsLink(g),"http://atlassian.com")});test("Sets the reports link correctly for Agile-provided reports link",function(){var g=this.sidebarWithReportsLink("com.pyxis.greenhopper.jira:global-sidebar-report");g.setReportsItemLink("http://some.other.link.com");equal(this.getReportsLink(g),"http://some.other.link.com")});test("When it receives a before:select event and it does not have a selected item, it retriggers the before:select with an additional flag",function(){var i=this.sidebarWithGroups();var g=this.spy(i,"retriggerPreventable");var h={emitter:i.getDefaultGroup(),isPrevented:false};var j=b.extend({isInitial:true},h);i.getDefaultGroup().trigger("before:select",h);sinon.assert.calledWith(g,"before:select",j)});test("When it receives a before:navigate:prevented event, it retriggers it",function(){var i=this.sidebarWithGroups();var g=this.spy(i,"trigger");var h={emitter:i.getDefaultGroup()};i.getDefaultGroup().trigger("before:navigate:prevented",h);sinon.assert.calledWith(g,"before:navigate:prevented",h)});test("When it contains a selected item, it returns the selected item when getSelectedNavigationItem is called",function(){var h=this.sidebarWithGroups();var g=h.getItem("my-navigation-item-1");g.select();ok(h.getSelectedNavigationItem()===g)});test("When does not contain a selected item, it returns undefined when getSelectedNavigationItem is called",function(){var g=this.sidebarWithGroups();ok(g.getSelectedNavigationItem()===undefined)});test("When it contains a selected item, it returns true when the hasASelectedItem method is called",function(){var g=this.sidebarWithGroups();g.getItem("my-navigation-item-1").select();ok(g.hasASelectedItem())});test("When it does not contain a selected item, it returns false when the hasASelectedItem method is called",function(){var g=this.sidebarWithGroups();ok(!g.hasASelectedItem())});test("It adds a dimmed attribute to the sidebar when the dim method is called",function(){var g=this.sidebarWithGroups();g.dim();ok(g.$el.is("[dimmed]"))});test("When the dim method is called multiple times the sidebar remains with a dimmed attribute",function(){var g=this.sidebarWithGroups();g.dim();g.dim();ok(g.$el.is("[dimmed]"))});test("It removes the dimmed attribute when undim is called",function(){var g=this.sidebarWithGroups();g.dim();g.undim();ok(!g.$el.is("[dimmed]"))});test("When dim is not called, undim behaves as a no-op",function(){var g=this.sidebarWithGroups();g.undim();ok(!g.$el.is("[dimmed]"))});test("It should know when it is in a global board context",function(){this.WRM.data.claim.reset();this.WRM.data.claim.withArgs("is-global-sidebar").returns(true);var i=this.context.require("jira/projects/sidebar/component");var h=new i();var g=h.isProjectSidebar();equal(this.WRM.data.claim.callCount,1);equal(g,false)});test("It should know when it is a project board context",function(){this.WRM.data.claim.reset();this.WRM.data.claim.withArgs("is-global-sidebar").returns(false);var i=this.context.require("jira/projects/sidebar/component");var h=new i();var g=h.isProjectSidebar();equal(this.WRM.data.claim.callCount,1);equal(g,true)});test("It can be re-rendered with new markup",function(){var h=this.sidebarWithGroups();var g=sinon.stub();h.on("render",g);h.render({el:['<div class="aui-sidebar">','   <div class="aui-sidebar-group" data-id="test-sidebar-group">',"      <ul>",'         <li><a class="aui-nav-item" data-link-id="test-sidebar-item"></a></li>','         <li><a class="aui-nav-item"></a></li>',"      </ul>","   </div>",'   <div class="aui-sidebar-group">',"      <ul>",'         <li><a class="aui-nav-item" data-link-id="test-sidebar-item-2"></a></li>',"      </ul>","   </div>","</div>"].join("")});sinon.assert.calledOnce(g);ok(h.getGroupAt(0) instanceof c);ok(h.getGroupAt(1) instanceof c);ok(h.getGroup("test-sidebar-group")===h.getGroupAt(0));ok(h.getGroup("test-sidebar-group").getItemAt(0) instanceof e.NavigationItem);ok(h.getGroup("test-sidebar-group").getItem("test-sidebar-item")===h.getGroup("test-sidebar-group").getItemAt(0))});test("It isn't re-rendered if the markup hasn't been updated",function(){var h=this.sidebarWithGroups();var g=sinon.stub();h.on("render",g);h.render();sinon.assert.notCalled(g)});test("It can be forced to re-render if necessary",function(){var h=this.sidebarWithGroups();var g=sinon.stub();h.on("render",g);h.render({force:true});sinon.assert.calledOnce(g)});test("It fires a 'detach' event when child components are destroyed",function(){var h=this.sidebarWithGroups();var g=sinon.stub();h.on("detach",g);h.render({force:true});sinon.assert.calledOnce(g)});test("It can be destroyed",function(){var h=this.sidebarWithGroups();var g=sinon.stub();h.on("destroy",g);h.destroy();sinon.assert.calledOnce(g)});test("It fires lifecycle events in the correct order",function(){var j=this.sidebarWithGroups();var k=sinon.stub();var g=sinon.stub();var l=sinon.stub();var h=sinon.stub();var i=sinon.stub();j.on("before:render",k);j.on("before:detach",g);j.on("detach",l);j.on("render",h);j.on("destroy",i);j.render({force:true});j.destroy();ok(k.calledBefore(g));ok(g.calledBefore(l));ok(l.calledBefore(h));ok(h.calledBefore(i));ok(i.calledOnce)});test("It only fires each lifecycle event once per cycle",function(){var j=this.sidebarWithGroups();var k=sinon.stub();var g=sinon.stub();var l=sinon.stub();var h=sinon.stub();var i=sinon.stub();j.on("before:render",k);j.on("before:detach",g);j.on("detach",l);j.on("render",h);j.on("destroy",i);j.render({force:true});j.destroy();sinon.assert.calledOnce(k);sinon.assert.calledOnce(g);sinon.assert.calledOnce(l);sinon.assert.calledOnce(h);sinon.assert.calledOnce(i)});test("When it is destroyed, events on the sidebar root are still bound",function(){var h=this.sidebarWithGroups();var g=sinon.stub();h.on("test-event",g);h.destroy();h.trigger("test-event");sinon.assert.calledOnce(g)});test("When it is destroyed, all event listeners are unbound from NavigationGroups",function(){var h=this.sidebarWithGroups();var i=h.getGroupAt(0);var g=sinon.stub();i.on("test-event",g);h.destroy();i.trigger("test-event");sinon.assert.notCalled(g)});test("When it is destroyed, all event listeners are unbound from NavigationSubgroups",function(){var h=this.sidebarWithSubgroups();var i=h.getGroupAt(0).getItemAt(0);var g=sinon.stub();i.on("test-event",g);h.destroy();i.trigger("test-event");sinon.assert.notCalled(g)});test("When it is destroyed, all event listeners are unbound from NavigationItems",function(){var i=this.sidebarWithGroups();var h=i.getGroup("sidebar-navigation-panel").getItem("my-navigation-item-1");var g=sinon.stub();h.on("test-event",g);i.destroy();h.trigger("test-event");sinon.assert.notCalled(g)});test("When it is re-rendered, events on the sidebar root are still bound",function(){var h=this.sidebarWithGroups();var g=sinon.stub();h.on("test-event",g);h.render({el:'<div class="aui-sidebar"></div>'});h.trigger("test-event");sinon.assert.calledOnce(g)});test("When it is re-rendered, event listeners are unbound from old NavigationGroups",function(){var h=this.sidebarWithGroups();var i=h.getGroupAt(0);var g=sinon.stub();i.on("test-event",g);h.render({el:'<div class="aui-sidebar"></div>'});i.trigger("test-event");sinon.assert.notCalled(g)});test("When it is re-rendered, event listeners are unbound from old NavigationSubgroups",function(){var h=this.sidebarWithSubgroups();var i=h.getGroupAt(0).getItemAt(0);var g=sinon.stub();i.on("test-event",g);h.render({el:'<div class="aui-sidebar"></div>'});i.trigger("test-event");sinon.assert.notCalled(g)});test("When it is re-rendered, event listeners are unbound from old NavigationItems",function(){var i=this.sidebarWithGroups();var h=i.getGroup("sidebar-navigation-panel").getItem("my-navigation-item-1");var g=sinon.stub();h.on("test-event",g);i.render({el:'<div class="aui-sidebar"></div>'});h.trigger("test-event");sinon.assert.notCalled(g)});test("When it is destroyed, it is removed from the page",function(){var h=this.sidebarWithGroups();var g=d("<div></div>").append(h.getElement());h.destroy();equal(g.find(".aui-sidebar").length,0)});test("When it is destroyed, its children no longer exist",function(){var g=this.sidebarWithGroups();g.destroy();equal(g.children.length,0)});test("Detach can be cancelled",function(){var h=this.sidebarWithGroups();var g=sinon.stub();h.on("before:detach",function(i){i.preventDefault()});h.on("detach",g);h.render({force:true});sinon.assert.notCalled(g)});test("Render can be cancelled",function(){var h=this.sidebarWithGroups();var g=sinon.stub();h.on("before:render",function(i){i.preventDefault()});h.on("render",g);h.render({force:true});sinon.assert.notCalled(g)});test("It doesn't continue with the render and detach action if 'before:render' is prevented",function(){var i=this.sidebarWithGroups();i.on("before:render",function(k){k.preventDefault()});var g=sinon.stub();var j=sinon.stub();var h=sinon.stub();i.on("before:detach",g);i.on("detach",j);i.on("render",h);i.render({force:true});sinon.assert.notCalled(g);sinon.assert.notCalled(j);sinon.assert.notCalled(h)});test("Sidebar render updates page DOM",function(){var h=this.sidebarWithGroups();var g=d('<div id="parent"></div>');g.append(h.$el);h.render({el:'<div class="aui-sidebar"></div>'});ok(h.$el.parent().length>0)})});