define("jira/api/projects/sidebar", ["jira/jquery/deferred", "exports"], function (Deferred, exports) {
    "use strict";

    var sidebarDeferred = new Deferred();
    var currentSidebarImpl = undefined;

    exports.getSidebar = function() {
        return sidebarDeferred.promise();
    };

    exports.initAPI = function(sidebarComponent) {
        // TODO We should add a simple facade to the component, so we only expose a
        // subset of the component's methods
        currentSidebarImpl = sidebarComponent;

        /**
         * @deprecated no more globals!
         * Use the {@link module:jira/api/projects/sidebar#getSidebar} method.
         */
        AJS.namespace('JIRA.API.Sidebar', null, currentSidebarImpl);

        // Open the floodgates, the consumers of the sidebar are here!
        sidebarDeferred.resolve(currentSidebarImpl);
    };
});

AJS.namespace("JIRA.API.getSidebar", null, require("jira/api/projects/sidebar").getSidebar);
