define("jira/projects/page/summary/navigation/subnavigator", [
    "jira/util/formatter",
    "jira/projects/components/subnavigator/subnavigator",
    "wrm/data",
    "exports"
], function(formatter, Subnavigator, wrmData, exports) {
    "use strict";

    exports.create = function(triggerPlaceholder, contentPlaceholder, titlePlaceholder) {
        return new Subnavigator({
            id: "summary-options",
            triggerPlaceholder: triggerPlaceholder,
            contentPlaceholder: contentPlaceholder,
            titlePlaceholder: titlePlaceholder,
            itemGroups: [{
                id: "activity",
                label: formatter.I18n.getText("project.page.summary.subnavigator.item.activity.label")
            }, {
                id: "statistics",
                label: formatter.I18n.getText("project.page.summary.subnavigator.item.statistics.label")
            }],
            selectedItem: wrmData.claim("mode"),
            hideSelectedItem: false,
            changeViewText: formatter.I18n.getText("project.page.summary.subnavigator.trigger")
        });
    };
});

AJS.namespace("JIRA.Projects.Summary.Subnavigator", null, require("jira/projects/page/summary/navigation/subnavigator"));
