define("jira/projects/page/summary/navigation/router", ["jira/projects/util/browser", "backbone", "wrm/context-path", "exports"], function(Browser, Backbone, wrmContextPath, exports) {
    "use strict";

    var Router = Backbone.Router.extend({
        routes: {
            ":statistics": function() {
                this.trigger("statistics");
            },
            "": function() {
                this.trigger("activity");
            }
        },

        goToStatistics: function() {
            this.navigate("statistics", {trigger: true});
        },

        goToActivity: function() {
            this.navigate("", {trigger: true});
        },

        getTransformedUrlForNonPushStateBrowser: function(projectKey) {
            // If we are using a pushState url (/statistics) in a non-pushState browser,
            // transform it to be hashed (#statistics). In other words, this is for convert
            // Chrome URLs into IE9 URLs.
            // The opposite case (IE9 URL to Chrome URL) is already handled nicely by Backbone.
            var originalUrl = Browser.getCurrentLocation().pathname;
            var browserSupportsPushState = Browser.hasPushState();
            var urlIsForPushStateBrowsers = originalUrl.match(/summary\/$/) || originalUrl.match(/summary\/statistics$/);

            if (!browserSupportsPushState && urlIsForPushStateBrowsers) {
                var newURL = originalUrl.replace(new RegExp("^" + wrmContextPath() + "/projects/" + projectKey + "/"), "").replace(/\//, "#");
                return wrmContextPath() + "/projects/" + projectKey + "/" + newURL;
            }
            return null;
        }
    });

    exports.create = function() {
        return new Router();
    };
});

AJS.namespace("JIRA.Projects.Summary.Router", null, require("jira/projects/page/summary/navigation/router"));
