AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-navigation-test",function(){var e=require("jquery");var b=require("jira/api/projects");var d=require("jira/message");var c=require("jira/projects/page/summary/navigation/navigation");var a=require("jira/projects/page/summary/navigation/router");var f=require("jira/projects/page/summary/navigation/subnavigator");module("jira/projects/page/summary/navigation/navigation",{setup:function(){this.sandbox=sinon.sandbox.create();this.subnavigator=f.create(e("<div/>"),e("<div/>"));this.router=a.create();this.el=e("<div/>");this.navigation=c.create();this.server=this.sandbox.useFakeServer();this.mockCurrentProject()},teardown:function(){this.sandbox.restore()},startNavigation:function(){this.navigation.start(this.el,this.subnavigator,this.router)},mockCurrentProject:function(){this.sandbox.stub(b,"getCurrentProjectKey").returns("KEY")},serverReturnsHtmlForStatisticsPage:function(g){this.mockServerResponse(/\/projects\/KEY\?selectedItem=com.atlassian.jira.jira-projects-plugin:issues-panel&decorator=none&contentOnly=true*/,[200,{"Content-Type":"text/html"},g])},serverReturnsErrorForStatisticsPage:function(){this.mockServerResponse(/\/projects\/KEY\?selectedItem=com.atlassian.jira.jira-projects-plugin:issues-panel&decorator=none&contentOnly=true*/,[500,{"Content-Type":"text/html"},"error"])},serverReturnsHtmlForActivityPage:function(g){this.mockServerResponse(/\/projects\/KEY\?selectedItem=com.atlassian.jira.jira-projects-plugin:project-activity-summary&decorator=none&contentOnly=true*/,[200,{"Content-Type":"text/html"},g])},serverReturnsErrorForActivityPage:function(){this.mockServerResponse(/\/projects\/KEY\?selectedItem=com.atlassian.jira.jira-projects-plugin:project-activity-summary&decorator=none&contentOnly=true*/,[500,{"Content-Type":"text/html"},"error"])},mockServerResponse:function(h,g){this.server.respondWith("GET",h,g)}});test("When statistics is selected on the subnavigator, the router navigates to the statistics url",function(){var g=this.sandbox.spy(this.router,"goToStatistics");this.startNavigation();this.subnavigator.trigger("itemSelected",{item:{id:"statistics"}});sinon.assert.called(g)});test("When activity is selected on the subnavigator, the router navigates to the activity url",function(){var g=this.sandbox.spy(this.router,"goToActivity");this.startNavigation();this.subnavigator.trigger("itemSelected",{item:{id:"activity"}});sinon.assert.called(g)});test("When the navigation is started, the subnavigator is displayed",function(){var g=this.sandbox.spy(this.subnavigator,"show");this.startNavigation();sinon.assert.called(g)});test("When the router navigates to the statistics url, the content for the statistics view is fetched from the server and rendered on the page",function(){this.serverReturnsHtmlForStatisticsPage("statistics-html");this.startNavigation();this.router.trigger("statistics");this.server.respond();equal(this.el.html(),"statistics-html")});test("When the router navigates to the statistics url, the subnavigator is told to display the statistics option",function(){this.serverReturnsHtmlForStatisticsPage("any-html");var g=this.sandbox.spy(this.subnavigator,"selectItem");this.startNavigation();this.router.trigger("statistics");this.server.respond();sinon.assert.calledOnce(g);sinon.assert.calledWith(g,"statistics")});test("When the router navigates to the statistics url an error is displayed if the server can not be contacted",function(){this.serverReturnsErrorForStatisticsPage();this.sandbox.stub(d,"showErrorMsg");this.startNavigation();this.router.trigger("statistics");this.server.respond();equal(d.showErrorMsg.callCount,1)});test("When the router navigates to the activity url, the content for the activity view is fetched from the server and rendered on the page",function(){this.serverReturnsHtmlForActivityPage("activity-html");this.startNavigation();this.router.trigger("activity");this.server.respond();equal(this.el.html(),"activity-html")});test("When the router navigates to the activity url, the subnavigator is told to display the activity option",function(){this.serverReturnsHtmlForActivityPage("any-html");var g=this.sandbox.spy(this.subnavigator,"selectItem");this.startNavigation();this.router.trigger("activity");this.server.respond();sinon.assert.calledOnce(g);sinon.assert.calledWith(g,"activity")});test("When the router navigates to the activity url an error is displayed if the server can not be contacted",function(){this.serverReturnsErrorForActivityPage();this.sandbox.stub(d,"showErrorMsg");this.startNavigation();this.router.trigger("activity");this.server.respond();equal(d.showErrorMsg.callCount,1)});test("When the content of the page is updated, an event is triggered",function(){this.serverReturnsHtmlForActivityPage("any-html");var g=this.spy(this.navigation,"trigger");this.startNavigation();this.router.trigger("activity");this.server.respond();sinon.assert.calledWith(g,"pageRefreshed")});test("When the statistics page is selected, an event is triggered",function(){var g=this.spy(this.navigation,"trigger");this.startNavigation();this.router.trigger("statistics");sinon.assert.calledWith(g,"statisticsPageSelected")});test("When the activity page is selected, an event is triggered",function(){var g=this.spy(this.navigation,"trigger");this.startNavigation();this.router.trigger("activity");sinon.assert.calledWith(g,"activityPageSelected")})});