require([
    "jira/projects/page/summary/navigation/subnavigator",
    "jira/projects/page/summary/navigation/router",
    "jira/projects/page/summary/navigation/navigation",
    "jira/projects/page/summary/navigation/navigation-analytics",
    "jira/projects/page/summary/issue/vignettes/navigation",
    "jira/projects/page/summary/issue/vignettes/analytics",
    "jira/projects/page/summary/issue/vignettes/switcher",
    "jira/projects/page/summary/issue/vignettes/manager",
    "jira/projects/page/summary/issue/vignettes/lastviewed/manager",
    "jira/projects/page/summary/navigation/gotostatistics",
    "jira/projects/util/browser",
    "jira/api/projects",
    "wrm/context-path",
    "backbone",
    "jquery"
], function(
    Subnavigator,
    Router,
    Navigation,
    NavigationAnalytics,
    issueVignetteNavigation,
    issueVignetteAnalytics,
    vignetteSwitcher,
    vignettes,
    lastViewedVignetteUpdater,
    statisticsLink,
    Browser,
    ProjectsAPI,
    wrmContextPath,
    Backbone,
    $
) {
    "use strict";

    $(function() {
        var router = Router.create();

        var subnavigator = Subnavigator.create($("#summary-subnav-trigger"), $("#summary-subnav-opts"), $("#summary-subnav-title"));

        var projectKey = encodeURIComponent(ProjectsAPI.getCurrentProjectKey());
        var transformedUrl = router.getTransformedUrlForNonPushStateBrowser(projectKey);
        if (transformedUrl) {
            Browser.locationReplace(transformedUrl);
            return;
        }

        var navigationAnalytics = NavigationAnalytics.create();
        var navigation = Navigation.create();

        issueVignetteAnalytics.startAnalyticsForGoToStatisticsLink(statisticsLink);
        issueVignetteAnalytics.startAnalyticsForVignetteNavigation(issueVignetteNavigation);
        issueVignetteAnalytics.startAnalyticsForVignettes(vignettes);

        navigationAnalytics.start(navigation);
        navigation.start($("#summary-body"), subnavigator, router);
        navigation.on("pageRefreshed", function () {
            vignettes.start();
            statisticsLink.start($("#statistics-link"), router);
            var switcher = vignetteSwitcher.start($("#vignette-switcher-trigger"), $("#vignette-switcher-opts"), $("#vignette-switcher-title"));
            issueVignetteNavigation.start(switcher, vignettes, lastViewedVignetteUpdater);
        });

        Backbone.history.start({
            pushState: true,
            root: wrmContextPath() + "/projects/" + projectKey + "/summary"
        });
    });
});
