define("jira/projects/page/summary/issue/vignettes/prioritysummary", [
    "aui/inline-dialog",
    "jira/projects/page/summary/issue/vignettes/templates",
    "jira/projects/util/browser",
    "jquery",
    "underscore",
    "backbone"
], function(AuiInlineDialog, Templates, Browser, $, _, Backbone) {
    "use strict";

    var events = {
        dialogShown: "priorityDialogShown",
        linkClicked: "priorityLinkClicked"
    };

    var registerClickEventForPriorityLinks = function(prioritySummary) {
        $(".priority-link").click(function(clickEvent) {
            clickEvent.preventDefault();
            var clickedPrioritySequence = clickEvent.target.getAttribute("data-priority-sequence");
            var clickedPriorityCount = clickEvent.target.getAttribute("data-priority-count");
            prioritySummary.trigger(events.linkClicked, {
                prioritySequence: clickedPrioritySequence,
                priorityCount: clickedPriorityCount
            });

            var linkDestination = clickEvent.target.getAttribute("href");
            Browser.locationAssign(linkDestination);
        });
    };

    var createPriorityDialog = function(prioritySummary) {
        var dialogTriggerEl = $("a#show-all-priorities").get(0);
        var priorityBreakdownDialog = new AuiInlineDialog(dialogTriggerEl, "priorities-dialog", function (content, trigger, showPopup) {

            var priorityList = JSON.parse(dialogTriggerEl.getAttribute("data-priority-counts"));

            content.html(Templates.priorityDialog({
                priorityList: priorityList
            }));
            showPopup();
            registerClickEventForPriorityLinks(prioritySummary);
            return false;
        }, {
            onHover: true,
            width: 260,
            initCallback: function() {
                prioritySummary.trigger(events.dialogShown);
            }
        });

        priorityBreakdownDialog.addClass("breakdown-dialog");
    };

    return _.extend({
        getEventNames: function() {
            return Object.keys(events).map(function(key) {
                return events[key];
            });
        },

        getId: function() {
            return "priority";
        },

        show: function() {
            $(".priority-vignette").removeClass("hidden");
        },

        hide: function() {
            $(".priority-vignette").addClass("hidden");
        },

        start: function() {
            createPriorityDialog(this);
            registerClickEventForPriorityLinks(this);
        }
    }, Backbone.Events);
});
