AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-assignee-summary-test-resources", function() {
    "use strict";

    var jQuery = require("jquery");
    var Browser = require("jira/projects/util/browser");

    module("jira/projects/page/summary/issue/vignettes/assigneesummary", {
        setup: function() {
            this.assigneeSummary = require("jira/projects/page/summary/issue/vignettes/assigneesummary");
            this.page = jQuery("#qunit-fixture");
        },
        stubRedirections: function() {
            return this.stub(Browser, "locationAssign");
        },
        attachLinkToPage: function(linkAttributes) {
            var link = jQuery("<a class='assignee-link' "
            + linkAttributes
            + "></a>");
            this.page.append(link);

            return link;
        },
        createLinkWithUsername: function(username) {
            if (username) {
                return this.attachLinkToPage("rel='" + username + "'");
            }
            return this.attachLinkToPage();
        },
        createLinkWithNoUsername: function() {
            return this.createLinkWithUsername();
        },
        createLinkWithHref: function(href) {
            return this.attachLinkToPage("href='" + href + "'");
        }
    });

    test("When an assignee link is clicked, a 'assigneeLinkClicked' event is triggered with the correct data", function() {
        this.stubRedirections();
        this.spy(this.assigneeSummary, "trigger");
        var expectedClickEventData = {
            isUnassigned: false
        };
        var assigneeLink = this.createLinkWithUsername("aUsername");

        this.assigneeSummary.start();
        assigneeLink.click();

        sinon.assert.calledWith(this.assigneeSummary.trigger, "assigneeLinkClicked", expectedClickEventData);
    });

    test("When the 'unassigned' link is clicked, a 'assigneeLinkClicked' event is triggered with the correct data", function() {
        this.stubRedirections();
        this.spy(this.assigneeSummary, "trigger");
        var expectedClickEventData = {
            isUnassigned: true
        };
        var assigneeLink = this.createLinkWithNoUsername();

        this.assigneeSummary.start();
        assigneeLink.click();

        sinon.assert.calledWith(this.assigneeSummary.trigger, "assigneeLinkClicked", expectedClickEventData);
    });

    test("When an assignee link is clicked, we navigate to the expected page", function() {
        var redirections = this.stubRedirections();
        var expectedUrl = "/some/url";
        var assigneeLink = this.createLinkWithHref(expectedUrl);

        this.assigneeSummary.start();
        assigneeLink.click();

        sinon.assert.calledWith(redirections, expectedUrl);
    });

    test("When getting all the event names for the vignette, we return the expected event names", function() {
        var expectedEvents = ["assigneeLinkClicked", "assigneeDialogShown"];
        expectedEvents.sort();

        var eventNames = this.assigneeSummary.getEventNames();
        eventNames.sort();

        deepEqual(eventNames, expectedEvents);
    });
});
