AJS.test.require("com.atlassian.jira.jira-projects-plugin:summary-page-issue-vignettes-analytics-test-resources", function() {
    "use strict";

    var _ = require("underscore");
    var Backbone = require("backbone");
    var analytics = require("jira/analytics");
    var VignetteAnalytics = require("jira/projects/page/summary/issue/vignettes/analytics");

    module("jira/projects/page/summary/issue/vignettes/analytics", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();
            this.statisticsLink = _.extend({}, Backbone.Events);
            this.vignetteNavigation = _.extend({}, Backbone.Events);
            this.vignettes = _.extend({}, Backbone.Events);

            this.issueVignetteAnalytics = VignetteAnalytics;
            this.issueVignetteAnalytics.startAnalyticsForGoToStatisticsLink(this.statisticsLink);
            this.issueVignetteAnalytics.startAnalyticsForVignetteNavigation(this.vignetteNavigation);
            this.issueVignetteAnalytics.startAnalyticsForVignettes(this.vignettes);
            this.sandbox.stub(analytics, "send");
        },
        teardown: function() {
            this.sandbox.restore();
        }
    });

    test("When the 'View all issue statistics' link is clicked, an analytics event is triggered", function() {
        this.statisticsLink.trigger("statisticsLinkClicked");

        sinon.assert.calledWith(analytics.send, {
            name: "jira.projects.summary.page.gotostatistics.link.clicked",
            data: undefined
        });
    });

    test("When the vignette subnavigator is used to switch between vignettes, an analytics event is triggered with the correct vignette", function() {
        var expectedData = {
            selectedItem: "a vignette"
        };

        this.vignetteNavigation.trigger("vignetteSelected", expectedData);

        sinon.assert.calledWith(analytics.send, {
            name: "jira.projects.summary.page.vignetteswitcher.item.selected",
            data: expectedData
        });
    });

    test("When a link of the status summary is clicked, an analytics event is triggered with the correct status category", function() {
        var expectedStatusCategoryName = "someCategory";

        this.vignettes.trigger("statusLinkClicked", {
            statusCategory: expectedStatusCategoryName
        });

        sinon.assert.calledWith(analytics.send, {
            name: "jira.projects.summary.page.statussummarybar.link.clicked",
            data: {
                statusCategory: expectedStatusCategoryName
            }
        });
    });

    test("When the status category breakdown is displayed, an analytics event is triggered with the correct event", function() {
        this.vignettes.trigger("statusDialogShown");

        sinon.assert.calledWith(analytics.send, {
            name: "jira.projects.summary.page.statussummarybar.category.breakdown.displayed",
            data: undefined
        });
    });

    test("When a link of the priority summary is clicked, an analytics event is triggered with the correct sequence and count", function() {
        var expectedEventData = {
            priorityCount: 1,
            prioritySequence: 1
        };

        this.vignettes.trigger("priorityLinkClicked", expectedEventData);

        sinon.assert.calledWith(analytics.send, {
            name: "jira.projects.summary.page.prioritysummary.link.clicked",
            data: expectedEventData
        });
    });

    test("When the extra priorities are displayed, an analytics event is triggered with the correct event", function() {
        this.vignettes.trigger("priorityDialogShown");

        sinon.assert.calledWith(analytics.send, {
            name: "jira.projects.summary.page.prioritysummary.more.priorities.displayed",
            data: undefined
        });
    });

    test("When a link of the assignee summary is clicked, an analytics event is triggered with the correct flag", function() {
        var expectedEventData = {
            isUnassigned: false
        };

        this.vignettes.trigger("assigneeLinkClicked", expectedEventData);

        sinon.assert.calledWith(analytics.send, {
            name: "jira.projects.summary.page.assigneesummary.link.clicked",
            data: expectedEventData
        });
    });

    test("When the extra assignees are displayed, an analytics event is triggered with the correct event", function() {
        this.vignettes.trigger("assigneeDialogShown");

        sinon.assert.calledWith(analytics.send, {
            name: "jira.projects.summary.page.assigneesummary.more.assignees.displayed",
            data: undefined
        });
    });
});
