AJS.test.require(['com.atlassian.jira.jira-projects-plugin:report-page-assets'], function(){
    "use strict";

    var $ = require("jquery");
    var analytics = require("jira/analytics");
    var reportAnalytics = require("jira/projects/page/report/analytics");

    module('jira/projects/page/report/analytics', {
        setup: function() {
            this.$reports = $(
                '<div class="reports">' +
                '	<h2 class="reports__category">Agile</h2>' +
                '	<ul class="reports__list" data-category-key="agile">' +
                '		<li class="reports__list__item">' +
                '			<a href="#agile" class="reports__list__report" data-report-key="key:agile">agile report</a>' +
                '		</li>' +
                '	</ul>' +
                '	<h2 class="reports__category">Other</h2>' +
                '	<ul class="reports__list" data-category-key="other">' +
                '		<li class="reports__list__item">' +
                '			<a href="#other" class="reports__list__report" data-report-key="key:other">other report</a>' +
                '		</li>' +
                '		<li class="reports__list__item">' +
                '			<a href="#other2" class="reports__list__report" data-report-key="key:other2">other report 2</a>' +
                '		</li>' +
                '	</ul>' +
                '</div>'
            );

            $('#qunit-fixture').append(this.$reports);
            sinon.stub(analytics, 'send');
            reportAnalytics();
        },
        teardown: function() {
            analytics.send.restore();
        }
    });

    test('Attaches analytics events to all report links and triggers them with right parameters on click', function () {
        this.$reports.find('.reports__list__report').click();

        ok(analytics.send.calledThrice);


        function assertAnalyticsTriggeredWith(callNumber, data) {
            var args = analytics.send.getCall(callNumber).args;
            equal(typeof args[0], 'object');
            equal(args[0].name, "jira.projects.report.clicked");
            deepEqual(args[0].data, data);
        }

        assertAnalyticsTriggeredWith(0, {
            report: "key:agile",
            category: "agile",
            listPosition: 1
        });
        assertAnalyticsTriggeredWith(1, {
            report: "key:other",
            category: "other",
            listPosition: 1
        });
        assertAnalyticsTriggeredWith(2, {
            report: "key:other2",
            category: "other",
            listPosition: 2
        });
    });

});

