define("jira/projects/page/release/release-page-data", [
    "jira/util/formatter",
    "jira/jquery/deferred",
    "jquery",
    "jira/api/projects",
    "jira/featureflags/feature-manager",
    "jira/ajs/ajax/smart-ajax",
    "wrm/data",
    "wrm/context-path"
], function(
    formatter,
    Deferred,
    $,
    Projects,
    FeatureManager,
    SmartAjax,
    WRMData,
    contextPath
) {
    "use strict";

    var releasePageData = new Deferred();
    $.ajax({
        type: 'GET',
        url: contextPath() + '/rest/projects/1.0/project/' + Projects.getCurrentProjectKey() + '/release/allversions',
        contentType: "application/json",
        timeout: 120000
    }).then(function(response) {
        releasePageData.resolve(response);
    }).fail(function(xhr) {
        releasePageData.reject(SmartAjax.buildSimpleErrorContent(xhr))
    });

    return releasePageData.promise();
});
