define("jira/projects/release/submit-controller", [
    "jira/projects/libs/marionette",
    "jira/ajs/ajax/ajax-util",
    "jira/flag",
    "jira/featureflags/feature-manager",
    "jira/projects/release/submit-view",
    "jira/projects/release/submit-model",
    "jira/projects/abstract-list/submit-controller",
    "jira/projects/abstract-model/submit-model-states"
], function(
    Marionette,
    ajaxUtil,
    jiraFlag,
    FeatureManager,
    SubmitView,
    SubmitModel,
    AbstractSubmitControler,
    SubmitModelStates
) {
    var SubmitController = AbstractSubmitControler.extend({
        initialize: function (options) {
            this._viewModel = new SubmitModel();
            this.pageableItems = options.pageableItems;
            this.isProjectAdmin = options.isProjectAdmin
        },

        showView: function () {
            var view = new SubmitView({
                model: this._viewModel,
                pageableItems: this.options.pageableItems
            });

            this.listenTo(view, "save", this.versionAdd);
            return view;
        },

        versionAdd: function (formModel) {
            var model = formModel.clone();

            this.listenTo(model, "retry-add", function () {
                this._versionAdd(model, false, SubmitModelStates.IN_PROGRESS_ERROR);
            });

            return this._versionAdd(model, true, SubmitModelStates.IN_PROGRESS);
        },

        _versionAdd: function (model, addToPageableItems, state) {
            model.set("state", state);
            if( addToPageableItems ){
                this.pageableItems.addElement(model);
            }
            model.save(state)
                .done(function () {
                    setTimeout(function () {
                        if (model.get("state") === SubmitModelStates.SUCCESSFUL) {
                            model.set("state", SubmitModelStates.READY);
                        }
                    }, 5000);
                    model.trigger('added', model);
                }.bind(this));

            return model;
        },

        displaySubmitView: function () {
            return this.isProjectAdmin;
        }
    });

    return SubmitController;
});
