define("jira/projects/release/searchlayoutview", [
    "jira/projects/page/release/view/filter",
    "jira/projects/release/noversionsitemview",
    "jira/projects/release/table-layout-view",
    "jira/projects/release/merge-view",
    "jira/projects/release/config-data-view",
    "jira/projects/release/templates",
    "jira/projects/libs/marionette",
    "backbone"
], function(
    FilterView,
    NoVersionsItemView,
    TableLayoutView,
    MergeView,
    ConfigDataView,
    Templates,
    Marionette,
    Backbone
) {
    "use strict";

    return Marionette.LayoutView.extend({
        template: Templates.searchLayout,
        regions: {
            submitRegion: "#submit-container",
            filterRegion: "#filter-container",
            mainRegion: "#content-container",
            mergeRegion: "#merge-container",
            configDataRegion: "#config-data-container"
        },

        initialize: function (options) {
            this.filter = options.filter;
            this.pageableItems = options.pageableItems;
            this.releaseLearnMoreUrl = options.releaseLearnMoreUrl;
            this.submitController = options.submitController;
            this.configDataModel = options.configDataModel;
            this.listenTo(this.pageableItems, "collectionChanged", this._renderMainRegion);
            this.isProjectAdmin = options.isProjectAdmin;
        },

        onRender: function () {
            if (this.submitController.displaySubmitView()) {
                this.submitRegion.show(this.submitController.showView());
            }

            this._renderMainRegion();
        },

        _renderMainRegion: function () {
            if (this.pageableItems.originalCollection.length === 0) {
                this.mainRegion.show(new NoVersionsItemView({
                    model: new Backbone.Model({learnMoreUrl: this.releaseLearnMoreUrl})
                }));
                this.filterRegion.empty();
                this.filter.emptyContainsField();
                this.mergeRegion.empty();
            } else {
                this.filterRegion.show(new FilterView({
                    model: this.filter,
                    isProjectAdmin: this.isProjectAdmin
                }));
                this.listenTo(this, "filterChanged", function () {
                    this.filterRegion.currentView.render();
                });

                var mainTableLayoutView = new TableLayoutView({
                    submitController: this._submitController,
                    collection: this.pageableItems
                });
                this.mainRegion.show(mainTableLayoutView);
                this.mainRegion.currentView.on("childview:progressDialogClicked", function () {
                    this.trigger("progressDialogClicked");
                }.bind(this));

                var mergeView = new MergeView({
                    pageableItems: this.pageableItems,
                    isProjectAdmin: this.isProjectAdmin
                });
                this.mergeRegion.show(mergeView);
            }

            var dataView = new ConfigDataView({
                model: this.configDataModel
            });
            this.configDataRegion.show(dataView);
        }
    });
});
