define('jira/projects/release/noversionsitemview',[
    "jira/projects/release/templates",
    "jira/projects/release/analytics",
    "jira/projects/libs/marionette"
], function(Templates, Analytics, Marionette) {
    "use strict";

    return Marionette.ItemView.extend({
        template: Templates.noVersions,

        ui: {
            "learnMoreLink": "#learn-more"
        },
        events: {
            "click @ui.learnMoreLink": "onLearnMoreClicked"
        },

        onRender: function onRender() {
            this.unwrapTemplate();
            Analytics.emptyViewRendered();
        },

        onLearnMoreClicked: function () {
            Analytics.releaseLearnMoreClicked();
        }
    });
});
