AJS.test.require(["com.atlassian.jira.jira-projects-plugin:release-page-assets"], function(){
    "use strict";

    var Backbone = require("backbone");
    var FilterView = require("jira/projects/page/release/view/filter");
    var FilterModel = require("jira/projects/release/filter-model");
    var Templates = require("jira/projects/release/templates");
    var jQuery = require("jquery");

    module('jira/projects/page/release/view/filter', {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.mockModel = new FilterModel(
                {
                    status: 'no-filter',
                    pageableCollection:
                    {
                        originalCollection: new Backbone.Collection(),
                        fullCollection:
                        {
                            reset: this.sandbox.spy()
                        },
                        resetFilter: sinon.spy(),
                        on: sinon.spy()
                    }
                });
            this.sandbox.spy(this.mockModel, "set");
            this.sandbox.spy(this.mockModel, "get");

            this.view = new FilterView({
                el: jQuery(
                    Templates.filter({
                        status: "no-filter",
                        contains: "",
                        showArchived: true
                    })
                ),
                model: this.mockModel,
                isProjectAdmin: true
            });
            this.view.bindUIElements();
        },
        teardown: function () {
            this.sandbox.restore();
        }
    });

    test('Should debounce contains input changes.', function () {
        this.sandbox.useFakeTimers();

        this.view.ui.contains.val("1");
        this.view.ui.contains.trigger("input");
        this.sandbox.clock.tick(99);
        this.view.ui.contains.trigger("change");
        this.sandbox.clock.tick(99);
        this.view.ui.contains.trigger("input");
        this.sandbox.clock.tick(100);

        sinon.assert.calledOnce(this.mockModel.set);
        sinon.assert.calledWith(this.mockModel.set, "contains", "1");
    });

    test('Should change status on click on the dropdown.', function () {
        this.view.ui.unreleased.click();
        sinon.assert.calledOnce(this.mockModel.set);
        sinon.assert.calledWith(this.mockModel.set, "status", "unreleased");
    });

    test('Should set status to no-filter when none dropdown items are selected.', function () {
        this.view.ui.unreleased.click();
        this.view.ui.unreleased.click();
        sinon.assert.calledTwice(this.mockModel.set);
        sinon.assert.calledWith(this.mockModel.set, "status", "no-filter");
    });

    test('Should set status to released-unreleased when first two dropdown items are selected.', function () {
        this.view.ui.unreleased.click();
        this.view.ui.released.click();
        sinon.assert.calledTwice(this.mockModel.set);
        sinon.assert.calledWith(this.mockModel.set, "status", "released-unreleased");
    });

    test('Should set status to all when all dropdown items are selected.', function () {
        this.view.ui.unreleased.click();
        this.view.ui.released.click();
        this.view.ui.archived.click();
        sinon.assert.calledThrice(this.mockModel.set);
        sinon.assert.calledWith(this.mockModel.set, "status", "all");
    });
});

