define("jira/projects/components/submitmodel", [
    "jira/util/logger",
    "jira/flag",
    "jira/ajs/ajax/ajax-util",
    "backbone",
    "underscore",
    "jquery",
    "wrm/context-path",
    "jira/projects/abstract-model/submit-model-states",
    "jira/projects/abstract-list/submit-model",
    "jira/projects/components/analytics"
], function(
    logger,
    jiraFlag,
    ajaxUtil,
    Backbone,
    _,
    $,
    contextPath,
    SubmitModelStates,
    AbstractSubmitModel,
    Analytics
) {
    var SubmitModel = AbstractSubmitModel.extend({
        defaults: _.extend({}, AbstractSubmitModel.prototype.defaults, {
            issuesCount: 0
        }),

        urlRoot: contextPath() + "/rest/api/2/component",
        detailsPath: function() {
            return contextPath() + '/rest/projects/1.0/project/' + encodeURIComponent(this.get("project")) + '/component/' + this.id;
        },

        initialize: function() {
            Analytics.listenForActionsOnItem(this);
        },

        destroy: function(options) {
            this.lastDestroyOptions = _.clone(options);
            var moveIssuesTo = parseInt(options.data.moveIssuesTo);
            var collection = this.collection;

            // should not send JSON in request body, end point coming from projects config plugin expecting query params instead
            options.url = this.url() + '?' + $.param(options.data);
            delete options.data;

            // do not remove model immediately, wait for REST result
            options.wait = true;

            //if model isNew then destroy returns false
            var result = Backbone.Model.prototype.destroy.apply(this, arguments);
            if (result) {
                if (moveIssuesTo > 0) {
                    this.trigger("swapItemEvent");
                    result.then(function () {
                        var targetCmp = collection.get(moveIssuesTo);
                        if (targetCmp) {
                            targetCmp.detailsSync().always(function () {
                                logger.trace("jira.components.delete.finished");
                            });
                        } else {
                            logger.trace("jira.components.delete.finished");
                        }
                    }.bind(this));
                } else {
                    result.always(function () {
                        logger.trace("jira.components.delete.finished");
                    })
                }

                this.trigger("removeItemEvent");

                // remove components from all collections, it is refactored on other branch
                result.fail(function (xhr) {
                    this.set("state", SubmitModelStates.ERROR_DELETE);
                    this.set("errorMsg", AJS.escapeHtml(ajaxUtil.getErrorMessageFromXHR(xhr)));
                }.bind(this));
            }

            return result;
        },

        toDataJSON: function() {
            return _.pick(this.toJSON(), "project", "description", "leadUserName", "name", "assigneeType");
        },

        getRelatedIssueCount: function(options) {
            options.success(this.get("issuesCount"));
        },

        getSwapComponentsJSON: function() {
            return this.collection.filter(function(model) {
                return model.id != this;
            }, this.get("id")).map(function(model) {
                return model.toJSON();
            });
        },

        _traceItemAdded: function () {
            logger.trace("jira.components.add.finished");
        }
    });

    return SubmitModel;
});