AJS.test.require(["com.atlassian.jira.jira-projects-plugin:components-page-assets"],function(){var e=require("jira/projects/libs/marionette");var d=require("backbone");var b=require("jquery");var c=require("jira/projects/abstract-model/submit-model-states");var a=require("jira/jquery/deferred");module("SubmitController",{setup:function(){this.context=AJS.test.mockableModuleContext();this.sandbox=sinon.sandbox.create();this.sandbox.useFakeServer();this.clock=sinon.useFakeTimers();this.modelSave=new a();this.modelDetails=new a();this.sandbox.stub(d.Model.prototype,"save").returns(this.modelSave);d.Model.prototype.detailsSync=this.sandbox.stub().returns(this.modelDetails);this.pageableItems={addElement:this.sandbox.stub()};this.featureManager={isFeatureEnabled:this.sandbox.stub()};this.flags={showErrorMsg:this.sandbox.stub()};this.context.mock("jira/featureflags/feature-manager",this.featureManager);this.context.mock("jira/projects/components/submitview",e.ItemView);this.context.mock("jira/projects/components/submitmodel",d.Model);this.context.mock("jira/flag",this.flags);this.context.mock("jira/ajs/ajax/ajax-util",this.mockAjaxUtil());this.submitController=this.context.require("jira/projects/components/submitcontroller")},teardown:function(){this.sandbox.restore()},mockAjaxUtil:function(){return{getErrorMessageFromXHR:function(){return""}}},newSubmitView:function(){return new this.submitController({pageableItems:this.pageableItems})},mockedModel:function(){return new d.Model({name:"some name",leadUserName:"some leadUserName",description:"some description"})}});test("SubmitView should be displayed if flag is enabled and user is admin",function(){var f=new this.submitController({isProjectAdmin:true});ok(f.displaySubmitView())});test("SubmitView should be hidden if user is not admin",function(){var f=new this.submitController({isProjectAdmin:false});ok(!f.displaySubmitView())});test("New element is added to pageableItems on view save event",function(){var g=this.newSubmitView();var f=g.showView();f.trigger("save",this.mockedModel());ok(this.pageableItems.addElement.calledOnce)});test("componentAdd should listen to model retry-add event",function(){var f=this.newSubmitView();f.listenTo=sinon.spy();f.componentAdd(this.mockedModel());sinon.assert.calledOnce(f.listenTo);equal(f.listenTo.args[0][1],"retry-add")});test("retry-add event after componentAdd should trigger save of model as for the normal paths",function(){var g=this.newSubmitView();g._componentAdd=sinon.spy();var f=g.componentAdd(this.mockedModel());f.trigger("retry-add");sinon.assert.calledTwice(g._componentAdd);ok(g._componentAdd.getCall(0).calledWith(f,true));ok(g._componentAdd.getCall(1).calledWith(f,false))});test("componentAdded should trigger change model state to SubmitModelStates.READY from SubmitModelStates.SUCCESSFUL",function(){var g=this.newSubmitView();var f=g.componentAdd(this.mockedModel());equal(f.get("state"),c.IN_PROGRESS);this.modelSave.resolve();f.set("state",c.SUCCESSFUL);this.modelDetails.resolve();this.clock.tick(6000);equal(f.get("state"),c.READY)});test("componentAdded should NOT trigger change model state to SubmitModelStates.READY from other state than SubmitModelStates.SUCCESSFUL",function(){var g=this.newSubmitView();var f=g.componentAdd(this.mockedModel());equal(f.get("state"),c.IN_PROGRESS);this.modelSave.resolve();this.modelDetails.resolve();this.clock.tick(500);f.set("state",c.ERROR_DELETE);this.clock.tick(6000);equal(f.get("state"),c.ERROR_DELETE)})});