define("jira/projects/components/filter-view", [
    "jira/projects/components/templates",
    "jira/projects/components/analytics",
    "jira/projects/libs/marionette",
    "underscore"
], function(Templates, Analytics, Marionette, _) {
    "use strict";

    return Marionette.ItemView.extend({
        template: Templates.filter,
        ui: {
            "form": "form",
            "contains": ".text"
        },
        events: {
            "submit @ui.form": "formSubmit",
            "input @ui.contains": "inputContains",
            "change @ui.contains": "inputContains"
        },
        initialize: function () {
            Analytics.listenForActionsOnItem(this);
        },
        formSubmit: function formSubmit(e) {
            e.preventDefault();
        },
        inputContains: _.debounce(function inputContains(e) {
            var filter = this.ui.contains.val();
            this.model.set("contains", filter);
            this.trigger("searchItemEvent");
        }, 300)
    });

});

AJS.namespace("JIRA.Projects.Components.FilterView", null, require("jira/projects/components/filter-view"));
