define('jira/projects/components/filter-model', [
    "jira/projects/abstract-list/filter-model",
    "jira/projects/abstract-model/submit-model-states",
    "jira/util/strings"
], function(ALFilterModel, SubmitModelStates, Strings) {
    "use strict";

    var FilterModel = ALFilterModel.extend({
        filterAttributes: ['contains'],
        defaults: {
            contains: ""
        },
        initialize: function initialize(options) {
            ALFilterModel.prototype.initialize.call(this, options);

            this.on("change:contains", this.filterCollection);
            this.on("change:contains", this.navigate);
        },

        _containsValue: function() {
            return (this.get("contains") || "").toLowerCase();
        },

        emptyContainsField: function () {
            this.set('contains', '');
        },

        elementMatchFilter: function(element) {
            var contains = this._containsValue();
            return (
                (element.get("name") && Strings.contains(element.get("name").toLowerCase(), contains)) ||
                (element.get("description") && Strings.contains(element.get("description").toLowerCase(), contains)) ||
                (element.get("leadUserDisplayName") && Strings.contains(element.get("leadUserDisplayName"), contains)) ||
                (element.get("state") === SubmitModelStates.IN_PROGRESS) ||
                (element.get("state") === SubmitModelStates.IN_PROGRESS_ERROR)
            );
        },

        filterCollection: function filterCollection() {
            var filtered = this.pageableCollection.originalCollection.models;
            if (this._containsValue() !== "") {
                filtered = filtered.filter(this.elementMatchFilter, this);
            }
            this.pageableCollection.resetFilter(filtered);
        }
    });

    return FilterModel;
});
