AJS.test.require(["com.atlassian.jira.jira-projects-plugin:abstract-list-page"], function(){
    "use strict";

    var NavigationUtils = require("jira/projects/abstract-list/navigation-utils");

    module('jira/projects/abstract-list/navigation-utils#getQueryStringParam', {
        teardown: function () {
            NavigationUtils.getQueryStringParam.location = window.location;
        }
    });

    test('Should return the value of requested parameter.', function () {
        var location = {
            search: "?param=value&param2=value2"
        };

        equal(NavigationUtils.getQueryStringParam("param", false, location), "value");
        equal(NavigationUtils.getQueryStringParam("param2", false, location), "value2");
    });

    test('Should return undefined if there are no params.', function () {
        var location = {
            search: ""
        };

        strictEqual(NavigationUtils.getQueryStringParam("param", false, location), undefined);
    });

    test('Should return undefined if param is not present.', function () {
        var location = {
            search: "?param=value"
        };

        strictEqual(NavigationUtils.getQueryStringParam("param2", false, location), undefined);
    });

    test('Should include location hash in the search if said so.', function () {
        var location = {
            search: "?param=value",
            hash: "#hash=true"
        };

        equal(NavigationUtils.getQueryStringParam("param", true, location), "value");
        equal(NavigationUtils.getQueryStringParam("hash", true, location), "true");
    });

    test('Should return undefined for falsy parameter key.', function () {
        var location = {
            search: "?param=value&param=value2",
            hash: "#param=value3"
        };

        strictEqual(NavigationUtils.getQueryStringParam("", false, location), undefined);
        strictEqual(NavigationUtils.getQueryStringParam(undefined, false, location), undefined);
    });

    test('Should return last if there are more than one parameter with the same name.', function () {
        var location = {
            search: "?param=value&param=value2",
            hash: "#param=value3"
        };

        equal(NavigationUtils.getQueryStringParam("param", false, location), "value2");
        equal(NavigationUtils.getQueryStringParam("param", true, location), "value3");
    });

    test('Should properly decode parameter values.', function () {
        var location = {
            search: "?param=%3Cvalue%3E&param2=some+text&param3=%3Csome+value%3E"
        };

        equal(NavigationUtils.getQueryStringParam("param", false, location), "<value>", "Should URI-decode the value.");
        equal(NavigationUtils.getQueryStringParam("param2", false, location), "some text", "Should change + to spaces.");
        equal(NavigationUtils.getQueryStringParam("param3", false, location), "<some value>", "Should URI-decode the value and change + to space.");
    });

    test('Should handle empty search and hash segments.', function () {
        var location = {
            search: "?&&=&=foo",
            hash: "#&&=&=bar"
        };

        strictEqual(NavigationUtils.getQueryStringParam("foo", false, location), undefined);
        strictEqual(NavigationUtils.getQueryStringParam("bar", true, location), undefined);
    });
});
