define("jira/projects/abstract-list/submit-model", [
    "jira/util/logger",
    "jira/jquery/deferred",
    "backbone",
    "jira/projects/abstract-model/submit-model-states",
    "jquery"
], function(logger, Deferred, Backbone, SubmitModelStates, $) {
    var SubmitModel = Backbone.Model.extend({
        defaults: {
            state: SubmitModelStates.READY
        },

        save: function(state) {
            this.set("state", state || SubmitModelStates.IN_PROGRESS);

            var deferred = new Deferred();

            Backbone.Model.prototype.save.call(this, [], {
                attrs: this.toDataJSON()
            }).done(function () {
                    this.detailsSync().always(function () {
                        this._traceItemAdded();
                        this.set("state", SubmitModelStates.SUCCESSFUL);
                        deferred.resolve();
                    }.bind(this));
                }.bind(this))
                .fail(function (xhr) {
                    this.set("state", SubmitModelStates.ERROR_ADD);
                    this._traceItemAdded();
                    deferred.reject(xhr);
                }.bind(this));

            return deferred;
        },

        _traceItemAdded: function () {
            logger.trace("jira.item.add.finished");
        },

        discard: function () {
            if (this.get("state") === SubmitModelStates.ERROR_ADD) {
                this.destroy({data: {}});
            } else if (this.get("state") === SubmitModelStates.ERROR_DELETE || this.get("state") === SubmitModelStates.ERROR_UPDATE) {
                this.set("state", SubmitModelStates.READY);
            }
        },

        /**
         * Synchronizes state with server.
         * Child implementations should implement detailsPath() function that should point to rest endpoint providing current data for specific item.
         */
        detailsSync: function() {
            return $.ajax({
                type: "GET",
                url: this.detailsPath(),
                contentType: "application/json"
            }).done(function(response) {
                this.set(response);
            }.bind(this));
        },

        isStateError: function () {
            return SubmitModelStates.isStateError(this.get('state'));
        },

        isStateErrorOrRetrying: function () {
            return SubmitModelStates.isStateErrorOrRetrying(this.get('state'));
        },

        addStateTimeout: function (from, to) {
            setTimeout(function () {
                if (this.get("state") === from) {
                    this.set("state", to);
                }
            }.bind(this), 5000);
        }
    });

    return SubmitModel;
});
