define('jira/projects/abstract-list/pagination-view', [
    "jira/projects/abstract-list/navigation-utils",
    "jira/projects/abstract-list/templates",
    "jira/projects/libs/marionette",
    "underscore",
    "jquery"
], function(NavigationUtils, Templates, Marionette, _, jQuery) {
    "use strict";

    return Marionette.ItemView.extend({
        template: Templates.pagination,
        ui: {
            page: "li a"
        },
        events: {
            "click @ui.page": "clickPage"
        },
        collectionEvents: {
            reset: "render"
        },
        modelEvents: {
            change: "render"
        },
        onRender: function onRender() {
            this.unwrapTemplate();
        },
        serializeData: function() {
            var url = NavigationUtils.getRoot() + this.model.getFilterQueryStringParams();
            var data =_.extend({
                url: url
            }, this.collection.state);
            data.firstPage = Math.max(data.currentPage - 5, data.firstPage);
            data.totalPages = data.lastPage;
            data.lastPage = Math.min(data.currentPage + 5, data.lastPage);
            return data;
        },
        clickPage: function clickPage(e) {
            e.preventDefault();
            var pageNumber = +jQuery(e.target).attr("data-page");
            if (pageNumber) {
                NavigationUtils.navigate(this.model.getFilterQueryStringParams() + "&page=" + pageNumber);
                this.collection.getPage(pageNumber);
                this.trigger("navigate", pageNumber);
            }
        }
    });
});

AJS.namespace('JIRA.Projects.AbstractList.PaginationView', null, require('jira/projects/abstract-list/pagination-view'));
