AJS.test.require(["com.atlassian.jira.jira-projects-plugin:abstract-list-page"], function(){
    "use strict";

    var _ = require("underscore");
    var Backbone = require("backbone");
    var LazyLoadingCollection = require("jira/projects/abstract-list/lazy-loading-collection");

    var DummyModel = Backbone.Model.extend({

    });
    var DummyCollection = Backbone.Collection.extend({
        model: DummyModel
    });

    var TestLazyLoadingCollection = LazyLoadingCollection.extend({
        collectionClass: DummyCollection
    });

    function stubAddingMethods(collection) {
        collection.originalCollection.add = sinon.spy();
        collection.fullCollection.add = sinon.spy();
        collection.add = sinon.spy();

        collection.filter.elementMatchFilter = sinon.stub();
        collection._findAddingIndex = sinon.stub();
    }

    module('jira/projects/abstract-list/lazy-loading-collection', {
        setup: function () {
            this.stubModelDataJson = function stubModelDataJson(count) {
                return _.range(count).map(function(id){
                    return {"id": id};
                });
            };
        },
        teardown: function () {
        }
    });

    test('Should add next slice from full collection on nextPage()', function () {
        var collection = new TestLazyLoadingCollection(null, {
            data: this.stubModelDataJson(30)
        });
        equal(collection.size(), 25);
        equal(collection.last().id, 24);

        collection.nextPage();
        equal(collection.size(), 30);
        equal(collection.last().id, 29);
    });

    test('When all elements loaded multiple calls on nextPage() should not cause any effect', function () {
        var collection = new TestLazyLoadingCollection(null, {
            data: this.stubModelDataJson(51)
        });

        equal(collection.nextPage(), true);
        equal(collection.size(), 50);

        equal(collection.nextPage(), false);
        equal(collection.size(), 51);
    });

    test('Should add new elements on matching indexes', function () {
        var collection = new TestLazyLoadingCollection(null, {
            data: []
        });

        stubAddingMethods(collection);

        var myModel = new DummyModel();
        collection.filter.elementMatchFilter.withArgs(myModel).returns(true);
        collection._findAddingIndex.withArgs(collection.originalCollection, myModel).returns(15);
        collection._findAddingIndex.withArgs(collection.fullCollection, myModel).returns(0);

        collection.addElement(myModel);

        sinon.assert.calledWith(collection.originalCollection.add, myModel, {at: 15});
        sinon.assert.calledWith(collection.fullCollection.add, myModel, {at: 0});
        sinon.assert.calledWith(collection.add, myModel, {at: 0});

    });

    test('Should not add to the fullCollection when element does not match filter', function() {
        var collection = new TestLazyLoadingCollection(null, {
            data: []
        });

        stubAddingMethods(collection);

        var myModel = new DummyModel();
        collection.filter.elementMatchFilter.withArgs(myModel).returns(false);
        collection._findAddingIndex.withArgs(collection.originalCollection, myModel).returns(13);

        collection.addElement(myModel);

        sinon.assert.calledWith(collection.originalCollection.add, myModel, {at: 13});
        sinon.assert.notCalled(collection.fullCollection.add);
        sinon.assert.notCalled(collection.add, myModel);
    });
});

