define("jira/projects/abstract-list/item-view", [
    "underscore",
    "jquery",
    "jira/flag",
    "jira/projects/abstract-model/submit-model-states",
    "jira/projects/abstract-list/templates",
    "jira/projects/libs/marionette",
    "jira/loading/loading"
], function(_, jQuery, jiraFlag, SubmitModelStates, Templates, Marionette, Loading) {
    "use strict";

    return Marionette.ItemView.extend({
        modelEvents: {
            "change": "_modelChange"
        },

        events: {
            "click @ui.retryAddButton": "_retryAddOperation",
            "click @ui.retryDeleteButton": "_retryDeleteOperation",
            "click @ui.retryUpdateButton": "_retryUpdateOperation",
            "click @ui.discard": "_discardOperation"
        },

        ui: {
            "retryAddButton": ".operation-retry.operation-add a.operation-retry",
            "retryDeleteButton": ".operation-retry.operation-delete a.operation-retry",
            "retryUpdateButton": ".operation-retry.operation-update a.operation-retry",
            "discard": ".operation-retry a.operation-discard"
        },

        _modelChange: function(model) {
            if (model.get("state") === SubmitModelStates.ERROR_DELETE) {
                this._showFlag();
            }

            this.render.apply(this, arguments);
        },

        listenToElements: function (events) {
            _.each(events, function (method, key) {
                var callback = this[method].bind(this);
                if (!callback) return;

                var eventName = key.substring(0, key.indexOf(" "));
                var selector = key.substring(eventName.length + 1);
                var element = this._getElement(selector);

                this._onElement(element, eventName, callback);
            }, this);
        },

        _onElement: function (element, eventName, callback) {
            if (element && element.length) {
                element.on(eventName, callback);
            }
        },

        _getElement: function (selector) {
            if (selector.indexOf("@ui.") === 0) {
                var uiElementName = selector.substring(4);
                return this.ui[uiElementName];
            } else {
                return jQuery(selector);
            }
        },

        onRender: function onRender() {
            this.unwrapTemplate();
        },

        _retryAddOperation: function (e) {
            e.preventDefault();
            this.model.trigger("retry-add", this.model);
        },

        _retryDeleteOperation: function (e) {
            e.preventDefault();
            this.model.trigger("retry-delete", this.model);
        },

        _retryUpdateOperation: function (e) {
            e.preventDefault();
            this.model.trigger("retry-update", this.model);
        },

        _discardOperation: function (event) {
            event.preventDefault();
            this.model.discard();
        },

        _showLoading: function () {
            AJS.dim();
            Loading.showLoadingIndicator();
        },

        _hideLoading: function () {
            AJS.undim();
            Loading.hideLoadingIndicator();
        },

        _showFlag: function() {
            if (this.$el.parents(".dynamic-table > .items").length == 0 || this.$el.isInView()) {
                return;
            }

            if (!this.flag) {
                this.flag = jiraFlag.showErrorMsg(null, Templates.deleteError({name: this.model.get("name")}));
                jQuery(this.flag).find(".dynamic_table__retry").on("click", function() {
                    this._deleteItemRetry();
                    this.flag.close();
                }.bind(this));
            }

            this.flag.setAttribute('aria-hidden', 'false');
        }
    });
});
