define('jira/projects/abstract-list/filter-model', ["jira/projects/abstract-list/navigation-utils", "backbone"], function(NavigationUtils, Backbone) {
    "use strict";

    return Backbone.Model.extend({
        filterAttributes: [],
        initialize: function initialize(options) {
            this.pageableCollection = options.pageableCollection;
            delete this.attributes.pageableCollection; // silently get rid of the set model attribute
        },
        filterCollection: function filterCollection() {
            var filtered = this.pageableCollection.originalCollection;
            this.pageableCollection.fullCollection.reset(filtered);
            this.pageableCollection.getPage("first");
        },
        navigate: function navigate() {
            NavigationUtils.navigate(this.getFilterQueryStringParams());
            this.trigger("navigate");
        },
        getFilterQueryStringParams: function getFilterQueryStringParams() {
            var filter = this.filterAttributes
                    .reduce(function (previous, current) {
                        var param = this.get(current);
                        if (param) {
                            return previous + "&" + encodeURIComponent(current) + "=" + encodeURIComponent(param);
                        }
                        return previous;
                    }.bind(this), "");
            if (!NavigationUtils.pushStateSupported) {
                filter = filter.substr(1)
            }
            return filter;
        }
    });
});

AJS.namespace('JIRA.Projects.AbstractList.FilterModel', null, require('jira/projects/abstract-list/filter-model'));
