define("jira/projects/abstract-list/effects", ["jira/jquery/deferred"], function(Deferred) {
    "use strict";

    return {
        onCollectionRemove: function (model) {
            var afterAnimation = new Deferred();
            var view = this.children.findByModel(model);

            if (view) {
                view.$el.addClass('transition-destroy');
                view.$('td > div').animate({height: 0}, 500, function () {
                        this.removeChildView(view);
                        this.checkEmpty();
                        afterAnimation.resolve();
                    }.bind(this)
                );
            } else {
                afterAnimation.resolve();
            }

            return afterAnimation;
        }
    };
});


