require(['jira/util/formatter', 'jira/util/browser', 'jira/ajs/ajax/smart-ajax', 'jira/dialog/form-dialog', 'jira-project-config/utils', 'jira-project-config/workflows/scheme/common', 'jira-project-config/application', 'wrm/context-path', "jquery"], function (formatter, browser, SmartAjax, FormDialog, ProjectConfigUtils, SchemeCommon, Application, wrmContextPath, $) {
    'use strict';

    var contextPath = wrmContextPath();

    /**
     * @param options.href target URI
     * @param options.issueTypeId 0 for workflow tab, otherwise issueTypeId (issuetype tab)
     */
    function showDialog(options) {
        var dialog = new FormDialog({
            id: "wait-migrate-dialog",
            content: function content(callback) {
                callback(JIRA.Templates.Workflows.EditDefault.defaultSchemeDialog());
            },
            submitHandler: function submitHandler(e, callback) {
                e.preventDefault();
                copyWorkflow(options, dialog);
                callback();
            }
        });
        dialog.addHeading(formatter.I18n.getText("admin.project.workflow.scheme.migration.prompt.heading"));
        dialog.show();
    }

    function initInitialWorkflowSchemeLinks($ctx) {
        $ctx.on('click', ".project-config-workflow-default a.project-config-workflow-edit", function (e) {
            e.preventDefault();
            var href = $(this).attr("href");

            showDialog({
                href: href
            });
        });

        $ctx.on('click', "#migrate_workflow", function (e) {
            e.preventDefault();

            showDialog({
                issueTypeId: this.dataset.issueTypeId
            });
        });
    }

    function copyWorkflow(href, dialog) {
        SmartAjax.makeWebSudoRequest({
            url: contextPath + "/rest/projectconfig/latest/workflow",
            type: 'POST',
            data: ProjectConfigUtils.getId(),
            contentType: 'application/json'
        }, {
            cancel: function cancel(e) {
                //Don't redirect on websudo cancel. We can display stuff as non-admin.
                e.preventDefault();
            }
        }).done(function (data) {
            var taskId = data.taskId;
            var workflowName = data.workflowName;
            if (taskId) {
                //we have to do this here to ensure that the dialog has content so we can change the elements.
                dialog.show();
                dialog.handleCancel = function () {};
                $("#wait-migrate-dialog .buttons").css('visibility', 'hidden');
                dialog.addHeading(formatter.I18n.getText("admin.project.workflow.scheme.migration.wait.heading"));
                $("#wait-migrate-dialog .form-body").html(JIRA.Templates.Workflows.EditDefault.defaultSchemeDialogProgress());
                $("#progress-bar-container").progressBar(0, {
                    height: "20px",
                    showPercentage: true
                });
                checkIfFinished(taskId, href, workflowName);
            } else {
                editWorkflow(href, workflowName);
            }
        }).fail(SchemeCommon.smartAjaxErrorHandler(SchemeCommon.errorDialog));
    }

    function checkIfFinished(taskId, successHref, workflowName) {
        SmartAjax.makeRequest({
            url: contextPath + "/rest/projectconfig/latest/migrationStatus/" + taskId,
            type: 'GET',
            contentType: 'application/json',
            success: function success(taskStatus) {
                if (taskStatus.finished) {
                    $("#progress-bar-container").progressBar(100);

                    if (!taskStatus.successful || taskStatus.numberOfFailedIssues > 0) {
                        var params = $.param({
                            projectId: ProjectConfigUtils.getId(),
                            taskId: taskId
                        });
                        browser.reloadViaWindowLocation(contextPath + "/secure/project/SelectProjectWorkflowSchemeStep3.jspa?" + params);
                    } else {
                        deleteTask(taskId, function () {
                            editWorkflow(successHref, workflowName);
                        });
                    }
                } else {
                    var progress = taskStatus.progress;
                    $("#progress-bar-container").progressBar(progress);
                    setTimeout(function () {
                        checkIfFinished(taskId, successHref, workflowName);
                    }, 1000);
                }
            },
            error: function error(a, b, c, response) {
                deleteTask(taskId);
                SchemeCommon.errorDialog(SmartAjax.buildSimpleErrorContent(response));
            }
        });
    }

    function deleteTask(taskId, callback) {
        SmartAjax.makeRequest({
            url: contextPath + "/rest/projectconfig/latest/migrationStatus/" + taskId,
            type: 'DELETE',
            contentType: 'application/json',
            complete: callback
        });
    }

    /**
     * If options.href is present, then browser will navigate to it (used in workflows tab).
     * If not, then:
     *  - for issueTypeId > 0 browser will navigate to editWorkflow in issuetype tab,
     *  - for issueType = 0 browser will navigate to editWorkflow in workflow tab.
     *
     * @param options.href target URI
     * @param options.issueTypeId 0 for workflow tab, otherwise issueTypeId (issuetype tab)
     */
    function editWorkflow(options, workflow) {
        var issueTypeId = parseInt(options.issueTypeId, 10);
        var href;

        if (options.href) {
            href = options.href.replace(/wfName=[^&]*/, "wfName=" + encodeURIComponent(workflow));
        } else if (issueTypeId) {
            href = Application.reqres.request("urls:issueTypes:editWorkflow", {
                project: ProjectConfigUtils.getKey(),
                issueType: issueTypeId
            });
        } else {
            href = Application.reqres.request("urls:workflows:editWorkflow", {
                project: ProjectConfigUtils.getKey(),
                workflow: workflow
            });
        }

        browser.reloadViaWindowLocation(href);
    }

    initInitialWorkflowSchemeLinks($(document));
});