define("jira-project-config/workflows/tab/view/workflow-scheme-header", ["require"], function (require) {
    "use strict";

    var jQuery = require('jquery');
    var _ = require('underscore');
    var Reasons = require('jira/util/events/reasons');
    var Types = require('jira/util/events/types');
    var Events = require('jira/util/events');
    var Backbone = require('jira-project-config/workflows/tab/lib/backbone');
    var ProjectWorkflowsTabTemplates = require('jira-project-config/workflows/tab/templates');
    var AddWorkflowDialogView = require('jira-project-config/workflows/dialogs/add-workflow-dialog-view');

    var wrmContextPath = require('wrm/context-path');
    var DiscardDraft = require('jira-project-config/workflows/dialogs/discard-draft');
    var Dimmer = require('jira-project-config/workflows/tab/utils/dimmer');

    return Backbone.View.extend({
        events: {
            "click #view-original": "viewOriginal",
            "click #view-draft": "viewDraft",
            "click #discard-draft": "discardDraft",
            "click #publish-draft": "publishDraft"
        },
        initialize: function initialize() {
            this.model.on("change:lastModifiedDate change:lastModifiedUser change:draftScheme change:shared change:hasDraft", this.render, this);
            this.model.get('mappings').on("add remove", this.render, this);
        },
        template: function template(data) {
            return ProjectWorkflowsTabTemplates.header(data);
        },
        render: function render() {
            this.$el.html(this.template(this.model.toJSON()));

            this.$("#project-config-workflow-add-button").click(_.bind(this.addWorkflow, this));

            //remove the inline dialog if it already exists since we are recreating it
            jQuery("#inline-dialog-project-config-workflow-scheme-shared").remove();

            Events.trigger(Types.NEW_CONTENT_ADDED, [this.$el, Reasons.workflowHeaderReady]);

            return this;
        },
        addWorkflow: function addWorkflow(e) {
            e.preventDefault();
            if (!jQuery(e.target).hasClass("disabled")) {
                new AddWorkflowDialogView({
                    assignedWorkflows: this.model.get('mappings').pluck('name')
                }).render().on("assignIssueTypes", this.assignIssueTypes, this);
            }
        },
        assignIssueTypes: function assignIssueTypes(e) {
            this.trigger("assignIssueTypes", e);
        },

        viewOriginal: function viewOriginal(e) {
            e.preventDefault();
            Dimmer.dim();
            this.model.viewOriginal({
                success: function success() {
                    Dimmer.undim();
                }
            });
        },
        viewDraft: function viewDraft(e) {
            e.preventDefault();
            Dimmer.dim();
            this.model.viewDraft({
                success: function success() {
                    Dimmer.undim();
                }
            });
        },
        discardDraft: function discardDraft() {
            var model = this.model;
            DiscardDraft(function (callback) {
                model.discardDraft({
                    success: function success() {
                        callback();
                        Dimmer.undim();
                    }
                });
            });
        },
        publishDraft: function publishDraft() {
            location.href = wrmContextPath() + "/secure/project/SelectProjectWorkflowSchemeStep2!default.jspa?" + jQuery.param({
                draftMigration: true,
                projectId: this.model.get("projectId"),
                schemeId: this.model.id
            });
        }

    });
});