AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:edit-workflow-scheme"],function(){"use strict";var e=require("underscore"),o=require("jira-project-config/backbone"),s=require("jira-project-config/workflows/scheme/editor/controller"),t=require("jira/jquery/deferred"),r=require("jira/util/events"),l=require("jira-project-config/workflows/scheme/editor/models/issue-type-collection"),a=require("jquery"),i=require("jira/message"),n=require("jira/util/events/reasons"),d=require("jira/ajs/ajax/smart-ajax"),w=require("jira/ajs/ajax/smart-ajax/web-sudo"),u=require("jira-project-config/templates/messages"),f=require("jira-project-config/workflows/scheme/editor/templates"),c=require("jira/util/events/types"),k=require("jira-project-config/workflows/scheme/editor/models/workflow-collection"),h=require("jira-project-config/workflows/scheme/editor/models/workflow"),p=require("jira-project-config/workflows/scheme/editor/views/workflow-scheme-header"),m=require("jira-project-config/workflows/scheme/editor/models/workflow-scheme"),g=require("jira-project-config/workflows/scheme/editor/views/workflow-scheme"),y=require("jira-project-config/workflows/scheme/editor/views/workflow");module("JIRA.Workflows.Scheme.Editor.Controller - Tests",{teardown:function(){this.sandbox.restore()},setup:function(){this.sandbox=sinon.sandbox.create(),this.bus=e.clone(o.Events)}}),test("Controller.load no scheme",function(){var e=this.sandbox.stub(d,"makeWebSudoRequest"),o=this,t=function(){this.renderError=o.sandbox.spy()},r=new s({pageView:t,model:a.noop,issueTypeModel:a.noop,viewEventBus:this.bus});r.load(),ok(r.page.renderError.calledOnce,"Render error called"),ok(!e.called,"Never made ajax request.")}),test("Controller.load good load",function(){var e=this.sandbox.stub(w,"makeWebSudoRequest"),o=this,r=function(){this.renderModel=o.sandbox.spy()},l=function(){this.load=o.sandbox.spy(),this.workflows={on:o.sandbox.spy()}},a=new s({pageView:r,model:l,issueTypeModel:l,schemeId:101010,url:"test",viewEventBus:this.bus}),i=new t;e.withArgs({url:"test101010",dataType:"json"}).returns(i.promise()),a.load(),ok(e.calledOnce,"Never made ajax request.");var n={issueTypes:{issueTypes:"test"},a:"c",description:""};i.resolveWith(window,[n]),ok(a.issueTypes.load.calledWithExactly(n.issueTypes),"Called with correct issueTypes data."),ok(a.model.load.calledWithExactly(n),"Called with correct scheme data."),ok(a.page.renderModel.calledWithExactly(a.model,a.issueTypes))}),test("Controller.load bad load",function(){var e=this.sandbox.stub(w,"makeWebSudoRequest"),o=this.sandbox.stub(JIRA.Workflows.Scheme.Common,"smartAjaxErrorHandler"),r=this,l=function(){this.renderError=r.sandbox.spy()},i=new s({pageView:l,model:a.noop,issueTypeModel:a.noop,schemeId:101010,url:"test",viewEventBus:this.bus}),n=new t;e.withArgs({url:"test101010",dataType:"json"}).returns(n.promise()),i.load(),ok(e.calledOnce,"Never made ajax request."),n.rejectWith(window,[]),ok(o.calledOnce);var d=o.args[0][0];ok(!i.page.renderError.called);d("With error String"),ok(i.page.renderError.calledOnce),ok(i.page.renderError.calledWithExactly("With error String"))}),test("Controller removeIssueType",function(){var e=this,o=new s({pageView:a.noop,model:function(){this.removeIssueType=e.sandbox.spy()},issueTypeModel:a.noop,viewEventBus:this.bus,url:"/test/",schemeId:10101});o.ajax=this.sandbox.spy();o.removeIssueType("workflow",1),ok(o.model.removeIssueType.calledWith("workflow",1)),ok(o.ajax.calledWith({url:o.resourceUrl()+"/issuetype",type:"DELETE",contentType:"application/json",data:JSON.stringify({issueTypes:[1],workflow:"workflow"})}))}),test("Controller removeWorkflow",function(){var e=this,o=new s({pageView:a.noop,model:function(){this.removeWorkflow=e.sandbox.stub()},issueTypeModel:a.noop,viewEventBus:this.bus,url:"/url/",schemeId:100});o.ajax=this.sandbox.spy(),o.model.removeWorkflow.returns("nextDefault"),o.removeWorkflow("name"),ok(o.model.removeWorkflow.calledWith("name")),ok(o.ajax.calledWith({url:o.resourceUrl()+"/workflow",type:"DELETE",contentType:"application/json",data:JSON.stringify({workflow:"name",nextDefaultWorkflow:"nextDefault"})}))}),test("Controller assignIssueTypes",function(){var e=this,o=new s({pageView:a.noop,model:function(){this.assignIssueTypes=e.sandbox.spy()},issueTypeModel:a.noop,viewEventBus:this.bus,url:"/url/",schemeId:100}),t=["1","2"];o.ajax=this.sandbox.spy(),o.assignIssueTypes("name",t,!1),ok(o.model.assignIssueTypes.calledWith("name",t,!1)),ok(o.ajax.calledWith({url:o.resourceUrl(),type:"PUT",contentType:"application/json",data:JSON.stringify({workflow:"name",issueTypes:t,defaultWorkflow:!1})}))}),test("Controller addWorkflow",function(){var e=this,o=new s({pageView:a.noop,model:function(){this.addWorkflow=e.sandbox.spy()},issueTypeModel:a.noop,viewEventBus:this.bus,url:"/url/",schemeId:100}),t={name:"name",default:!0,issueTypes:[]};o.ajax=this.sandbox.spy(),o.addWorkflow(t),ok(o.model.addWorkflow.calledWith(t)),ok(o.ajax.calledWith({url:o.resourceUrl(),type:"PUT",contentType:"application/json",data:JSON.stringify({workflow:t.name,issueTypes:t.issueTypes,defaultWorkflow:t.default})}))}),test("Controller discardDraft",function(){var e=this,o=new s({pageView:a.noop,model:function(){this.discardDraft=e.sandbox.spy()},issueTypeModel:a.noop,viewEventBus:this.bus,url:"/url/",schemeId:100});o.ajax=this.sandbox.spy(),o.discardDraft(),ok(o.model.discardDraft.calledWith()),ok(o.ajax.calledWith({url:o.resourceUrl()+"/draft",type:"DELETE",contentType:"application/json"}))}),test("Controller loadModel",function(){var e=this,o=function(){this.load=e.sandbox.stub()},t=function(){this.load=e.sandbox.stub()},r=new s({pageView:a.noop,model:o,issueTypeModel:t,viewEventBus:{on:a.noop}}),l={issueTypes:"something",description:""};r.model.load.returns(!0),r.issueTypes.load.returns(!0),ok(r.loadModel(l)),ok(r.model.load.calledWithExactly(l)),ok(r.issueTypes.load.calledWithExactly(l.issueTypes)),r.model.load.returns(!0),r.issueTypes.load.returns(!1),ok(r.loadModel(l)),r.model.load.returns(!1),r.issueTypes.load.returns(!0),ok(r.loadModel(l)),r.model.load.returns(!1),r.issueTypes.load.returns(!1),ok(!r.loadModel(l))}),test("Controller ajax success no change",function(){var e=new t,o=this.sandbox.stub(w,"makeWebSudoRequest"),r=this.sandbox.stub(i,"showWarningMsg");o.returns(e.promise());var l=this,n=new s({pageView:function(){this.setLoading=a.noop,this.renderModel=l.sandbox.spy()},model:function(){this.setDraft=l.sandbox.spy()},issueTypeModel:a.noop,viewEventBus:{on:a.noop}});n.loadModel=this.sandbox.stub(),n.loadModel.returns(!1),ok(n.ajax()),ok(o.called),e.resolveWith(void 0,[{}]),ok(!r.called),ok(!n.page.renderModel.called),ok(!n.model.setDraft.called)}),test("Controller ajax success change",function(){var e=new t,o=this.sandbox.stub(w,"makeWebSudoRequest"),r=this.sandbox.stub(i,"showWarningMsg");o.returns(e.promise());var l=this,n=new s({pageView:function(){this.setLoading=a.noop,this.renderModel=l.sandbox.spy()},model:function(){this.setDraft=l.sandbox.spy()},issueTypeModel:a.noop,viewEventBus:{on:a.noop}});n.loadModel=this.sandbox.stub(),n.loadModel.returns(!0),ok(n.ajax()),ok(o.called),e.resolveWith(void 0,[{}]),ok(r.called),ok(!n.model.setDraft.called)}),test("Controller ajax fail",function(){var e=this.sandbox.stub(w,"makeWebSudoRequest"),o=this.sandbox.stub(JIRA.Workflows.Scheme.Common,"smartAjaxErrorHandler"),r=new t;e.returns(r.promise());var l=this,i=new s({pageView:function(){this.setLoading=a.noop},model:function(){this.setDraft=l.sandbox.spy()},issueTypeModel:a.noop,viewEventBus:{on:a.noop}}),n=this.sandbox.spy();o.returns(n),ok(i.ajax()),ok(e.called),ok(o.calledWithExactly(JIRA.Workflows.Scheme.Common.refreshErrorDialog)),ok(i.requests),r.rejectWith(window,[]),ok(n.called),ok(!i.requests),ok(!i.model.setDraft.called)}),test("Controller constructor binds to bus events",function(){var e=new s({pageView:a.noop,model:a.noop,issueTypeModel:a.noop,viewEventBus:{on:this.sandbox.spy()}});e.viewEventBus.on.calledWith("removeIssueType",e.removeIssueType,e),e.viewEventBus.on.calledWith("removeWorkflow",e.removeWorkflow,e),e.viewEventBus.on.calledWith("assignIssueTypes",e.assignIssueTypes,e),e.viewEventBus.on.calledWith("addWorkflow",e.addWorkflow,e),expect(0)}),module("JIRA.Workflows.Scheme.Editor.Model - Tests",{teardown:function(){this.sandbox.restore()},setup:function(){this.sandbox=sinon.sandbox.create(),this.bus=e.clone(o.Events)}}),test("WorkflowSchemeModel sets correctly",function(){var e=new m,o={name:"WorkflowSchemeModel",mappings:[{name:"Workflow1"},{name:"Workflow2"}],issueTypes:"name"};ok(e.load(o),"Returns true if changed."),deepEqual(e.workflows.toJSON(),o.mappings,"Mappings should be in its own collection."),deepEqual(e.toJSON(),{name:"WorkflowSchemeModel"},"Workflow Scheme Model correctly copied.")}),test("WorkflowSchemeModel load",function(){var o=new m({}),s=function(s){var t=o.toJSON();t.mappings=o.workflows.toJSON(),ok(e.isEqual(s,t))},t={mappings:[{name:"workflow1",issueTypes:[]},{name:"workflow2",issueTypes:[]}],name:"",description:"",draftScheme:"",shared:"",totalWorkflows:""};ok(o.load(t)),ok(!o.load(t)),s(t),t.mappings[1].name="workflow3",ok(o.load(t)),ok(!o.load(t)),s(t),t.name="something",ok(o.load(t)),ok(!o.load(t)),s(t),t.ignoredProperty="this will not matter",ok(!o.load(t)),s(t),t.mappings[1].issueTypes=["1","2"],ok(o.load(t)),ok(!o.load(t)),s(t),t.mappings[1].issueTypes=["2","1"],ok(!o.load(t)),t.mappings[1].issueTypes=["1","2"],s(t),t.mappings[1].issueTypes=["1"],ok(o.load(t)),ok(!o.load(t)),s(t),t.mappings.reverse(),ok(!o.load(t)),t.mappings.reverse(),s(t)}),test("WorkflowSchemeModel removeIssueType on non-default workflow",function(){var e=new m;e.workflows.add({default:!1,issueTypes:["1","2","3"],name:"workflow"}),e.removeIssueType("workflow","1"),deepEqual(e.workflows.get("workflow").toJSON(),{default:!1,issueTypes:["2","3"],name:"workflow"}),e.removeIssueType("workflow","2"),deepEqual(e.workflows.get("workflow").toJSON(),{default:!1,issueTypes:["3"],name:"workflow"}),e.removeIssueType("workflow","3"),ok(!e.workflows.get("workflow"))}),test("WorkflowSchemeModel removeIssueType on default workflow",function(){var e=new m;e.workflows.add({default:!0,issueTypes:["1","2","3"],name:"workflow"}),e.removeIssueType("workflow","1"),deepEqual(e.workflows.get("workflow").toJSON(),{default:!0,issueTypes:["2","3"],name:"workflow"}),e.removeIssueType("workflow","2"),deepEqual(e.workflows.get("workflow").toJSON(),{default:!0,issueTypes:["3"],name:"workflow"}),e.removeIssueType("workflow","3"),deepEqual(e.workflows.get("workflow").toJSON(),{default:!0,issueTypes:[],name:"workflow"})}),test("WorkflowSchemeModel removeWorkflow on non-default workflow",function(){var e=new m;e.workflows.add({default:!1,name:"workflow"});var o=e.workflows.get("workflow");o.destroy=this.sandbox.spy(),ok(void 0===e.removeWorkflow("workflow")),ok(o.destroy.calledWith())}),test("WorkflowSchemeModel removeWorkflow on default workflow with other workflow",function(){var e=new m;e.workflows.add({default:!0,name:"workflow"}),e.workflows.add({default:!1,name:"workflowNewDefault"});var o=e.workflows.get("workflow");this.sandbox.spy(o,"destroy"),ok("workflowNewDefault"===e.removeWorkflow("workflow")),deepEqual(e.workflows.get("workflowNewDefault").toJSON(),{default:!0,name:"workflowNewDefault"}),ok(o.destroy.calledWith())}),test("WorkflowSchemeModel removeWorkflow on default workflow with no other workflow",function(){var e=new m;e.workflows.add({default:!0,name:"workflow"});var o=e.workflows.get("workflow");this.sandbox.spy(o,"destroy"),ok(void 0===e.removeWorkflow("workflow")),ok(o.destroy.calledWith())}),test("WorkflowSchemeModel assignIssueTypes do not reassign default",function(){var e=new m;e.workflows.add({default:!1,issueTypes:["1"],name:"workflow"}),e.workflows.add({default:!0,issueTypes:["2"],name:"workflow2"}),e.assignIssueTypes("workflow",["2"],!1),deepEqual(e.workflows.get("workflow").toJSON(),{default:!1,issueTypes:["1","2"],name:"workflow"}),deepEqual(e.workflows.get("workflow2").toJSON(),{default:!0,issueTypes:[],name:"workflow2"})}),test("WorkflowSchemeModel assignIssueTypes do reassign default",function(){var e=new m;e.workflows.add({default:!1,issueTypes:["1"],name:"workflow"}),e.workflows.add({default:!0,issueTypes:["2"],name:"workflow2"}),e.workflows.add({default:!1,issueTypes:["3","4"],name:"workflow3"}),e.assignIssueTypes("workflow",["3","2"],!0),deepEqual(e.workflows.get("workflow").toJSON(),{default:!0,issueTypes:["1","3","2"],name:"workflow"}),ok(!e.workflows.get("workflow2")),deepEqual(e.workflows.get("workflow3").toJSON(),{default:!1,issueTypes:["4"],name:"workflow3"})}),test("WorkflowSchemeModel addWorkflow do not reassign default",function(){var e=new m;e.workflows.add({default:!1,issueTypes:["1"],name:"workflow"}),e.workflows.add({default:!0,issueTypes:["2"],name:"workflow2"}),e.addWorkflow({name:"workflow3",issueTypes:["2","4"],default:!1,displayName:"workflow3",description:"description"}),deepEqual(e.workflows.get("workflow").toJSON(),{default:!1,issueTypes:["1"],name:"workflow"}),deepEqual(e.workflows.get("workflow2").toJSON(),{default:!0,issueTypes:[],name:"workflow2"}),deepEqual(e.workflows.get("workflow3").toJSON(),{default:!1,issueTypes:["2","4"],name:"workflow3",displayName:"workflow3",description:"description"})}),test("WorkflowSchemeModel addWorkflow do reassign default",function(){var e=new m;e.workflows.add({default:!1,issueTypes:["1"],name:"workflow"}),e.workflows.add({default:!0,issueTypes:["2"],name:"workflow2"}),e.addWorkflow({name:"workflow3",issueTypes:["2","4"],default:!0,displayName:"workflow3",description:"workflow3"}),deepEqual(e.workflows.get("workflow").toJSON(),{default:!1,issueTypes:["1"],name:"workflow"}),deepEqual(e.workflows.get("workflow3").toJSON(),{default:!0,issueTypes:["2","4"],name:"workflow3",displayName:"workflow3",description:"workflow3"})}),test("WorkflowSchemeModel discardDraft",function(){var e=new m;e.set({draftScheme:!0,lastModifiedDate:"something",lastModifiedUser:"user",other:"other"});var o=[{name:"workflow3"},{name:"workflow4"}];e.workflows.reset([{name:"workflow1"},{name:"workflow2"}]),e.originalWorkflows.reset(o),e.discardDraft(),deepEqual(e.toJSON(),{draftScheme:!1,other:"other"},"Cleared out the correct state."),deepEqual(e.workflows.toJSON(),o,"Original -> Current"),deepEqual(e.originalWorkflows.length,0,"Original Cleared")}),test("IssueTypeCollection load",function(){var e=[{name:"issuetype1"},{name:"issuetype2"}],o=[{name:"issuetype1"},{name:"issuetype3"}],s=new l(e);s.reset=this.sandbox.spy(),ok(!s.load(e)),ok(!s.reset.called),ok(s.load(o)),ok(s.reset.called)}),test("WorkflowModel equalsObject",function(){var e={name:"workflow",default:!0,issueTypes:["1","2"]},o=new h(e);ok(o.equalsObject(e));var s=a.extend(!0,{},e);ok(o.equalsObject(s)),s.default=!1,ok(!o.equalsObject(s));var t=a.extend(!0,{},e);ok(o.equalsObject(t)),t.name="different name",ok(!o.equalsObject(t));var r=a.extend(!0,{},e);ok(o.equalsObject(r)),r.issueTypes.reverse(),ok(o.equalsObject(r)),r.issueTypes.pop(),ok(!o.equalsObject(r))}),test("WorkflowCollection equalsArray",function(){var e=[{name:"workflow1",default:!0,issueTypes:["1","2"]},{name:"workflow2",default:!1,issueTypes:["3","4"]}],o=new k(e);ok(o.equalsArray(e));var s=a.extend(!0,[],e);s.pop(),ok(!o.equalsArray(s));var t=a.extend(!0,[],e);t.push({name:"workflow3",default:!1,issueTypes:["5"]}),ok(!o.equalsArray(t));var r=a.extend(!0,[],e);r[0].issueTypes.reverse(),ok(o.equalsArray(r)),r[0].issueTypes.pop(),ok(!o.equalsArray(r))}),module("JIRA.Workflows.Scheme.Editor.View - Tests",{teardown:function(){this.sandbox.restore()},setup:function(){this.sandbox=sinon.sandbox.create(),this.Templates=f,this.bus=e.clone(o.Events)}}),test("WorkflowSchemeHeaderView",function(){var s=this.sandbox.spy(AJS,"format"),t={key:"ONE",name:"Project One",id:1},i={key:"TWO",name:"Project Two",id:2},d={name:"workflow1"},w={name:"workflow2"},u={name:"Scheme2",draftScheme:!1,shared:{sharedWithProjects:[t,i],sharedWithIssueTypes:[],totalProjectsCount:3,hiddenProjectsCount:1},totalWorkflows:3},f={name:"Scheme1",draftScheme:!0,shared:{sharedWithProjects:[],sharedWithIssueTypes:[],totalProjectsCount:0,hiddenProjectsCount:0},lastModifiedDate:"Last Date",lastModifiedUser:{displayName:"User Display",name:"User"},currentUser:"User"},h=new o.Model(u),p=new k([d,w]),m=new l([]),g=AJS.test.mockableModuleContext(),y=this.stub(r);g.mock("jira/util/events",y);var v=this.stub();g.mock("jira-project-config/workflows/dialogs/discard-draft",v);var T=g.require("jira-project-config/workflows/scheme/editor/views/workflow-scheme-header"),b=new T({bus:this.bus,issueTypes:m,workflows:p,editable:!0,model:h}),W={events:[],register:function(o){o.on("all",function(){this.events.push(e.toArray(arguments))},this)},clear:function(){this.events=[]},calledWith:function(){var o=e.toArray(arguments);return e.any(this.events,function(s){return e.isEqual(s,o)})}},x=function(e){this.view=e,this.selectors={publish:"#publish-draft",discard:"#discard-draft",viewOriginal:"#view-original",viewDraft:"#view-draft",addWorkflow:"#add-workflow-dropdown li:has(#add-workflow), #add-workflow-dropdown-trigger",schemeName:"#workflow-scheme-name",draftStatus:".status-draft",sharedBy:".used-by",projects:".shared-projects-list a",draftInfo:".last-edited"},this.name=function(){return this.view.$(this.selectors.schemeName).val()},this.draft=function(){return this.view.$(this.selectors.draftStatus).length>0},this.draftInfo=function(){return this.view.$(this.selectors.draftInfo).length>0},this.shared=function(){if(this.view.$(this.selectors.sharedBy).length){var e=[];return this.view.$(this.selectors.projects).each(function(){e.push(a.trim(a(this).text()))}),e}return null},this.getDraftInfo=function(){if(!this.draft())return null;var e=function(e){return e.calledWith("admin.workflowscheme.last.edited.by.you.at")?{you:!0,time:e.args[1]}:!!e.calledWith("admin.workflowscheme.last.edited.by.user.at")&&{you:!1,name:e.args[1],time:e.args[2]}},o=e(s.getCall(s.callCount-1))||e(s.getCall(s.callCount-2));if(o)return o;throw new Error("Title did not match expected info.")},this.canPublish=function(){return null!==this.findOrNull(this.selectors.publish)},this.canDiscard=function(){return null!==this.findOrNull(this.selectors.discard)},this.canViewOriginal=function(){return null!==this.findOrNull(this.selectors.viewOriginal)},this.canViewDraft=function(){return null!==this.findOrNull(this.selectors.viewDraft)},this.canAddWorkflow=function(){var e=this.view.$(this.selectors.addWorkflow);return e.length>0&&!e.hasClass("disabled")},this.viewOriginal=function(){return this.click(this.selectors.viewOriginal,"View Original")},this.viewDraft=function(){return this.click(this.selectors.viewDraft,"View Draft")},this.discard=function(){return this.click(this.selectors.discard,"Discard Draft")},this.findOrNull=function(e){var o=this.view.$(e);return 0===o.length?null:o},this.click=function(e,o){var s=this.findOrNull(e);if(!s)throw new Error("Unable to perform '"+o+"' link not present.");return s.click(),this}},E=function(o,s,t,r){equal(r.name(),o.get("name"),"Workflow has correct name?");var l=o.get("draftScheme");if(l)if(t)ok(!r.draft(),"Workflow original should not be draft?"),ok(!r.canPublish(),"Can't publish from original screen."),ok(!r.canDiscard(),"Can't discard from original screen"),ok(!r.canViewOriginal(),"Can't view original from original screen."),ok(r.canViewDraft(),"Can view draft from original screen."),ok(!r.draftInfo(),"No draft info.");else{var a=null,i=o.get("lastModifiedUser"),n=o.get("lastModifiedDate");if(i&&n){var d=i.name===o.get("currentUser");a={you:d,time:n},d||(a.name=i.displayName)}deepEqual(r.getDraftInfo(),a,"Draft Info correct?"),ok(r.draft(),"Workflow should not be draft?"),ok(r.canPublish(),"Can publish from draft screen."),ok(r.canDiscard(),"Can discard from draft screen"),ok(r.canViewOriginal(),"Can view original from draft screen."),ok(!r.canViewDraft(),"Can't view draft from draft screen.")}else ok(!r.draft(),"Workflow scheme is not draft?"),ok(!r.canPublish(),"Can't publish inactive ?"),ok(!r.canDiscard(),"Can't discard inactive ?"),ok(!r.canViewOriginal(),"Can't see original of inactive ?"),ok(!r.canViewDraft(),"Can't see original of inactive ?"),ok(!r.draftInfo(),"No draft info.");var w=o.get("shared");w.sharedWithProjects.length>0?deepEqual(r.shared(),e.pluck(w.sharedWithProjects,"name"),"Sharing information correct"):ok(!r.shared(),"Not shared."),l&&t||s.length>=o.get("totalWorkflows")?ok(!r.canAddWorkflow(),"Should not be able to add workflow."):ok(r.canAddWorkflow(),"Should be able to add workflow")},D=new x(b.render());equal(y.trigger.callCount,1,"Trigged NEW_CONTEXT_ADDED."),ok(y.trigger.lastCall.calledWith(c.NEW_CONTENT_ADDED,[b.$el,n.workflowHeaderReady]),"Content added triggered."),E(h,p,!1,D),p.add({name:"workflow3"}),E(h,p,!1,D),equal(y.trigger.callCount,1,"Don't trigger NEW_CONTEXT_ADDED."),p.remove(p.get("workflow3")),E(h,p,!1,D),equal(y.trigger.callCount,1,"Don't trigger NEW_CONTEXT_ADDED."),h.set(f),equal(y.trigger.callCount,2,"Trigged NEW_CONTEXT_ADDED."),ok(y.trigger.lastCall.calledWith(c.NEW_CONTENT_ADDED,[b.$el,n.workflowHeaderReady]),"Content added triggered."),E(h,p,!1,D),W.register(this.bus),D.viewOriginal(),equal(y.trigger.callCount,3,"Trigged NEW_CONTEXT_ADDED."),ok(y.trigger.lastCall.calledWith(c.NEW_CONTENT_ADDED,[b.$el,n.workflowHeaderReady]),"Content added triggered."),ok(W.calledWith("viewOriginal"),"View Original event triggered."),E(h,p,!0,D),W.clear(),D.viewDraft(),equal(y.trigger.callCount,4,"Trigged NEW_CONTEXT_ADDED."),ok(y.trigger.lastCall.calledWith(c.NEW_CONTENT_ADDED,[b.$el,n.workflowHeaderReady]),"Content added triggered."),ok(W.calledWith("viewDraft"),"View Draft event triggered."),E(h,p,!1,D),p.add({name:"workflow5"}),E(h,p,!1,D),W.clear(),D.viewOriginal(),equal(y.trigger.callCount,5,"Trigged NEW_CONTEXT_ADDED."),ok(y.trigger.lastCall.calledWith(c.NEW_CONTENT_ADDED,[b.$el,n.workflowHeaderReady]),"Content added triggered."),ok(W.calledWith("viewOriginal"),"View Original event triggered."),E(h,p,!0,D),W.clear(),D.viewDraft(),h.set("currentUser","notMe"),equal(y.trigger.callCount,7,"Trigged NEW_CONTEXT_ADDED."),ok(y.trigger.lastCall.calledWith(c.NEW_CONTENT_ADDED,[b.$el,n.workflowHeaderReady]),"Content added triggered."),ok(W.calledWith("viewDraft"),"View Draft event triggered."),E(h,p,!1,D),p.remove(p.get("workflow5")),E(h,p,!1,D),equal(y.trigger.callCount,7,"Don't trigger NEW_CONTEXT_ADDED.");var j=this.sandbox.spy();W.clear(),v.yields(j),D.discard(),ok(W.calledWith("discardDraft"),"Discard Draft called."),E(h,p,!1,D),ok(j.calledWith(),"Triggered the callback.")}),test("WorkflowSchemeHeaderView assignAfterAdd",function(){var e=AJS.test.mockableModuleContext(),o=this.sandbox.stub();e.mock("jira-project-config/workflows/dialogs/assign-issue-types",o),new(e.require("jira-project-config/workflows/scheme/editor/views/workflow-scheme-header"))({model:{workflows:new k([{name:"workflow1",default:!0}]),on:a.noop},workflows:{on:a.noop,toJSON:a.noop},issueTypes:{toJSON:a.noop}}).assignAfterAdd({}),ok(o.called)}),test("WorkflowSchemeHeaderView canAddWorkflow",function(){var e=new p({model:{on:a.noop,get:this.sandbox.stub()},workflows:{on:a.noop,length:1}});e.model.get.withArgs("totalWorkflows").returns(2),ok(e.canAddWorkflow()),e.model.get.withArgs("totalWorkflows").returns(1),ok(!e.canAddWorkflow())}),test("WorkflowView initialize",function(){var e={issueTypes:"something",model:{on:this.sandbox.spy()}},o=new y(e);strictEqual(o.issueTypes,e.issueTypes),ok(e.model.on.calledWithExactly("change",o.render,o)),ok(e.model.on.calledWithExactly("destroy",o.unrender,o))}),test("WorkflowView template",function(){var e=this.sandbox.stub(this.Templates,"WorkflowView");e.returnsArg(0);var o={someKey:"some data"},s={issueTypes:"",model:{on:a.noop}},t=new y(s);strictEqual(t.template(o),o),ok(e.calledWithExactly(o))}),test("WorkflowView render",function(){var e={issueTypes:["issueType1"]},o={issueTypes:new l([{id:"issueType1",name:"issueType1"},{id:"issueType2",name:"issueType2"}]),model:{get:this.sandbox.stub(),on:a.noop,toJSON:this.sandbox.stub(),collection:{length:2}},editable:!0},s=new y(o);s.template=this.sandbox.stub(),s.template.returns("some html"),s.$el.html=this.sandbox.spy(),o.model.get.returns("some name"),o.model.toJSON.returns(e);var t=s.render();ok(s.template.calledWithExactly({issueTypes:[{id:"issueType1",name:"issueType1"}],showAssign:!1,editable:!0})),ok(s.$el.html.calledWithExactly("some html")),ok(s===t,"Invalid view")}),test("WorkflowView viewWorkflowText",function(){var e=this.sandbox.stub(JIRA.Workflows.Scheme.Common,"showWorkflowTextView"),o="some id",s={model:{id:o,on:a.noop}},t=new y(s),r={preventDefault:this.sandbox.spy()};t.viewWorkflowText(r),ok(r.preventDefault.called),ok(e.calledWithExactly({workflowName:o}))}),test("WorkflowView removeAllIssueTypes",function(){var e={model:{id:"workflow",on:a.noop,destroy:this.sandbox.spy()},bus:{trigger:this.sandbox.spy()}},o=new y(e),s={preventDefault:this.sandbox.spy()};o.removeAllIssueTypes(s),ok(s.preventDefault.called),ok(e.bus.trigger.calledWith("removeWorkflow",e.model.id))}),test("WorkflowView removeIssueType",function(){var e={model:{id:"workflow",on:a.noop,set:this.sandbox.spy(),get:this.sandbox.stub()},bus:{trigger:this.sandbox.spy()}},o=new y(e),s={preventDefault:this.sandbox.spy(),currentTarget:"<span data-issue-type='1'></span>"};o.removeIssueType(s),ok(s.preventDefault.called),ok(e.bus.trigger.calledWith("removeIssueType",e.model.id,"1"))}),test("WorkflowSchemeView",function(){function e(e){this.options=e,this.render=function(){return this.$el=a("<div>").attr("id","header"),this}}function o(e){this.model=e.model,this.name=this.model.id,this.options=e,this.render=function(){var e=a("<tr>").attr("id","row-"+this.name);return a("<td>").text(this.name).data("editable",this.options.editable).appendTo(e),this.$el=e,this},this.unrender=function(){this.$el.remove()}}var s={issueTypes:new l([]),model:{workflows:new k([{name:"workflow1"},{name:"workflow2"}]),originalWorkflows:new k([{name:"workflow4"},{name:"workflow3"}]),get:a.noop},bus:this.bus,headerViewCotr:e,workflowViewCotr:o},t=s.model.workflows,r=new g(s);r.render();var i=function(e,o){var s=r.$("td");equal(e.length,s.length,"Right number of expectedWorkflows?");for(var t=0;t<e.length;t++){var l=a(s[t]),i=e[t];equal(l.text(),i,"Expected workflow["+t+"]  to be "+i),equal(l.data("editable"),o,"Expected workflow["+t+"] to be "+(o?"":"NOT ")+" editable.")}};equal(r.$el.find("#header").length,1,"Is header rendered?"),i(["workflow1","workflow2"],!0),this.bus.trigger("viewOriginal"),i(["workflow4","workflow3"],!1),this.bus.trigger("viewDraft"),i(["workflow1","workflow2"],!0),t.add({name:"workflow7"}),i(["workflow1","workflow2","workflow7"],!0),this.bus.trigger("viewOriginal"),i(["workflow4","workflow3"],!1),this.bus.trigger("viewDraft"),i(["workflow1","workflow2","workflow7"],!0),t.reset([{name:"workflow8"},{name:"workflow9"}]),i(["workflow8","workflow9"],!0)}),test("Page view",function(){var e=AJS.test.mockableModuleContext(),o=this.sandbox.stub(u);e.mock("jira-project-config/workflows/scheme/editor/templates",o);var s,t=o.errorMessage,r=this.sandbox.spy(),l=function(e){s=e,this.render=function(){return this.$el="something",this},this.finalize=r};e.mock("jira-project-config/workflows/scheme/editor/views/workflow-scheme",l);var i=e.require("jira-project-config/workflows/scheme/editor/views/page"),n={on:a.noop},d=new i({bus:n});d.$el={removeClass:this.sandbox.stub(),html:this.sandbox.spy(),toggleClass:this.sandbox.spy(),closest:this.sandbox.stub()},d.$el.removeClass.returns(d.$el),d.$el.closest.returns(d.$el);d.html("some html"),ok(d.$el.removeClass.calledWithExactly("workflowscheme-editor-loading")),ok(d.$el.html.calledWithExactly("some html"));d.html=this.sandbox.spy(),t.returns("something"),d.renderError("something"),ok(t.calledWithExactly({message:"something"})),ok(d.html.calledWithExactly("something"));var w={workflows:{on:this.sandbox.spy(),length:1},on:a.noop,get:a.noop};d.html=this.sandbox.spy(),d.renderModel(w,"issueTypes"),ok(!r.called),deepEqual(s,{model:w,issueTypes:"issueTypes",bus:n}),ok(d.html.calledWithExactly("something")),d.renderModel(w,"issueTypes"),ok(w.workflows.on.calledWith("add remove")),ok(w.workflows.on.calledWith("reset")),ok(d.$el.toggleClass.calledWith("multiple-workflows",!1)),ok(r.called)})});