define("jira-project-config/workflows/dialogs/add-workflow-dialog-view", ["require"], function (require) {
    "use strict";

    var jQuery = require('jquery');
    var FormDialog = require('jira/dialog/form-dialog');
    var Backbone = require('jira-project-config/backbone');
    var TemplatesDialogs = require('jira-project-config/workflows/scheme/dialogs/templates');
    var WorkflowCollection = require('jira-project-config/workflows/dialogs/models/workflows');
    var AddWorkflowDialogWorkflowView = require('jira-project-config/workflows/dialogs/add-workflow-dialog-workflow-view');

    return Backbone.View.extend({
        events: {
            "click .project-config-workflow-add-dialog-list li": "viewWorkflow",
            "click #add-workflow-next": "assignIssueTypes"
        },
        initialize: function initialize() {
            this.collection = new WorkflowCollection();
            this.workflowView = null;
            this.workflowDialog = null;
        },
        template: function template(data) {
            return TemplatesDialogs.add(data);
        },
        render: function render() {
            var that = this;
            that.workflowDialog = new FormDialog({
                id: "add-workflow-dialog",
                widthClass: "large",
                stacked: true,
                content: function content(ready) {
                    that.collection.fetch({
                        success: function success(collection) {
                            ready(that.template({
                                workflows: collection.remove(that.options.assignedWorkflows).toJSON()
                            }));

                            that.setElement("#add-workflow-dialog");
                            that.workflowDialog.get$popupContent().find(".project-config-workflow-add-dialog-list li").first().click();
                        }
                    });
                }
            });
            that.workflowDialog.show();

            return this;
        },
        remove: function remove() {
            if (this.workflowView && this.workflowView.remove) {
                this.workflowView.remove();
            }
            if (this.workflowDialog && this.workflowDialog.destroy) {
                this.workflowDialog.destroy();
            }
        },
        viewWorkflow: function viewWorkflow(e) {
            var $dialog = this.$el;
            var $this = jQuery(e.target);
            var workflowName = $this.data("workflowname");
            var workflowModel = this.collection.get(workflowName);

            $dialog.find("#add-workflow-next").data("workflow", workflowModel.toJSON());

            if (!$this.hasClass("selected")) {
                $dialog.find(".selected").removeClass("selected");
                $this.addClass("selected");
                if (this.workflowView && this.workflowView.remove) {
                    this.workflowView.remove();
                }
                this.workflowView = new AddWorkflowDialogWorkflowView({
                    el: "#project-config-workflow-add-dialog-preview",
                    model: workflowModel
                }).render();
            }
        },
        assignIssueTypes: function assignIssueTypes(e) {
            e.preventDefault();
            this.trigger("assignIssueTypes", e);
        }
    });
});