define('jira-project-config/workflow/module', ['jira-project-config/workflow/controller', 'jira-project-config/workflow/model', 'jira-project-config/workflow/router', 'jira-project-config/workflow/entities/manager'], function (WorkflowController, WorkflowModel, WorkflowRouter, Manager) {
    "use strict";

    /**
     * @class
     * @classdesc
     *  Initializes MVC for workflow.
     *  Adds handlers to the application's reqres to expose workflow entities.
     * @constructor
     * @extends Marionette.Module
     */

    return function (module, application) {
        var reqres = application.reqres;

        module.addInitializer(function () {
            var controller;
            var manager = new Manager({
                reqres: reqres
            });

            reqres.setHandlers({
                workflowData: {
                    callback: manager.workflowData,
                    context: manager
                }
            });

            controller = new WorkflowController({
                application: application,
                model: new WorkflowModel(),
                region: application.content
            });

            new WorkflowRouter({ controller: controller });
        });

        module.addFinalizer(function () {
            reqres.removeHandler("workflowData");
        });
    };
});