define("jira-project-config/workflow/model", ["jira-project-config/backbone"], function (Backbone) {
  "use strict";

  /**
   * @class
   * @extends Backbone.Model
   */

  return Backbone.Model.extend(
  /** @lends JIRA.ProjectConfig.Workflow.Model# */
  {
    defaults: {
      /**
       * If true, means that the user has indicated they want to be in edit mode.
       *
       * @memberof JIRA.ProjectConfig.Workflow.Model#
       * @type {boolean}
       */
      editing: false,

      /**
       * The project currently being viewed, or null.
       * @memberof JIRA.ProjectConfig.Workflow.Model#
       * @type {JIRA.ProjectConfig.IssueTypes.Entities.Project|null}
       */
      project: null,

      /**
       * The workflow currently being viewed/edited, or null.
       * @memberof JIRA.ProjectConfig.Workflow.Model#
       * @type {JIRA.ProjectConfig.IssueTypes.Entities.Workflow|null}
       */
      workflow: null,

      /**
       * Dummy issue type model for compatibility purposes (ie. Header)
       * @memberof JIRA.ProjectConfig.Workflow.Model#
       * @type {JIRA.ProjectConfig.IssueTypes.Entities.IssueType|null}
       */
      selectedIssueType: null
    }
  });
});