define('jira-project-config/workflow/entities/ajax/project-workflow-manager', ['jira/ajs/ajax/smart-ajax', 'underscore', 'jira/jquery/deferred'], function (SmartAjax, _, jQueryDeferred) {
    "use strict";

    /**
     * An object that provides an interface to interact with REST APIs
     *
     * @constructor
     * @param {Marionette.RequestResponse} options.reqres A reqres that supports the following:
     *   - `urls:workflows:rest:workflow`
     */

    return function (options) {

        return {
            /**
             * Returns the workflow information for an issue type in a project.
             *
             * @param {string} projectKey
             * @param {string} workflowName
             * @returns a jQuery promise that is resolved with JSON decoded data from the REST API, or
             *     rejected with the jqXHR.
             *
             * Example data:
             *
             *     {
             *         name: "jira",
             *         displayName: "JIRA default workflow",
             *         state: "pending",
             *         sharedWithIssueTypes: ["1", "5", "3"],
             *         sharedWithProjects: [
             *             {
             *                 id: 123,
             *                 key: "FOO",
             *                 name: "Fast Or Out",
             *                 url: "/jira/...",
             *                 description: "A bit of this and that."
             *             }
             *         ]
             *     }
             */
            workflow: function workflow(projectKey, workflowName) {
                var deferred = jQueryDeferred();

                _.bindAll(deferred, "reject");

                this._makeRequest({
                    dataType: "json",
                    url: options.reqres.request("urls:workflows:rest:workflow", {
                        project: projectKey,
                        workflow: workflowName
                    })
                }).done(function (data) {
                    deferred.resolve(data);
                }).fail(deferred.reject);

                return deferred.promise();
            },

            /**
             * Make an AJAX request.
             *
             * Also attaches a CSRF token to the request
             *
             * @param {object} options Options to pass to `jQuery.ajax()`.
             * @protected
             */
            _makeRequest: function _makeRequest(options) {
                var deferred = jQueryDeferred();

                options.headers = _.extend({}, options.headers, {
                    "X-Atlassian-Token": "no-check"
                });

                SmartAjax.makeRequest(options, {}).done(deferred.resolve.bind(deferred)).fail(function (jqXHR) {
                    deferred.reject(jqXHR);
                });

                return deferred.promise();
            }
        };
    };
});