define('jira-project-config/summary/init-summary', ['jira/dialog/form-dialog', 'jquery', 'jira/analytics'], function (FormDialog, jQuery, analytics) {
    'use strict';

    function initSummaryPage() {
        var $emailLink = jQuery("#project-config-email-change");

        if ($emailLink.length === 1) {
            new FormDialog({
                id: "project-email-dialog",
                trigger: $emailLink
            });
        }

        new FormDialog({
            type: "ajax",
            id: "project-config-project-edit-lead-and-default-assignee-dialog",
            trigger: "#edit_project_lead,#edit_default_assignee",
            autoClose: true,
            onSuccessfulSubmit: function onSuccessfulSubmit() {}
        });

        jQuery(".project-config-workflow-edit").tooltip().mouseenter(function () {
            analytics.send({ name: 'jira.projectconfig.summary.workflowedit.link.hovered' });
        }).click(function () {
            analytics.send({ name: 'jira.projectconfig.summary.workflowedit.link.clicked' });
        });
    }

    return {
        init: initSummaryPage
    };
});