define('jira-project-config/summary/discover/discover-view', ['jira-project-config/marionette'], function (Marionette) {
    "use strict";

    return Marionette.ItemView.extend({
        ui: {
            "close": ".discover-close button",
            "learnMore": ".help-lnk"
        },

        events: {
            "click @ui.close": "close",
            "click @ui.learnMore": "learnMore"
        },

        template: JIRA.Templates.ProjectConfig.EditWorkflow.Discover.info,

        initialize: function initialize() {
            this.$el.find(".discover-close button").tooltip();
        },

        close: function close(e) {
            e.preventDefault();
            this.$el.hide();
            this.trigger('close');
        },

        learnMore: function learnMore() {
            this.trigger('learnMore');
        },

        discoveryType: function discoveryType() {
            return this.$el.data("discovery-type");
        }
    });
});