require(['jquery', 'jira/skate', 'wrm/data', 'jira-project-config/screen-editor', 'jira-project-config/global/js/analytics-common-data'], function ($, skate, wrmData, ScreenEditorApplication, AnalyticsCommonData) {
    "use strict";

    var screenInfo = wrmData.claim("com.atlassian.jira.jira-project-config-plugin:screenEditInfo");

    skate('project-screen-editor-placeholder', {
        type: skate.type.CLASSNAME,
        attached: function initScreenEditor(element) {
            var $el = $(element);
            new ScreenEditorApplication({
                element: $el,
                screenId: screenInfo.screenId,
                readOnly: !screenInfo.canEdit,
                projectKey: screenInfo.projectKey,
                analyticsName: "projectScreens",
                analyticsData: AnalyticsCommonData
            });
        }
    });
});