define("jira-project-config/screen-editor/edit-tab", ['jira-project-config/screen-editor/base-add-edit-dialog', 'jquery', 'jira/util/formatter', 'underscore'], function (BaseAddEditDialog, jQuery, formatter, _) {
    "use strict";

    /**
     * Contents of add tab inline dialog
     */

    return BaseAddEditDialog.extend({

        initialize: function initialize(options) {
            this.selectedTabId = parseInt(options.selectedTabId);
            this.selectedTabName = _.find(options.tabs, function (tab) {
                return tab.id === this.selectedTabId;
            }.bind(this)).name;
            this._name = this.selectedTabName;
            this._submitButtonText = formatter.I18n.getText('common.words.save');
        },

        submitDeferred: function submitDeferred(name) {
            if (name !== this.selectedTabName) {
                return this.model.renameTab(this.selectedTabId, name);
            } else {
                return jQuery.Deferred().resolve().promise();
            }
        }
    });
});