define("jira-project-config/screen-editor/base-add-edit-dialog", ['jira-project-config/screen-editor/template', 'jira-project-config/screen-editor/utils', 'jira-project-config/marionette', 'aui/inline-dialog', 'jira/util/logger'], function (TemplateScreenEditor, Utils, Marionette, inlineDialog, logger) {
    "use strict";

    /**
     * Contents of add tab inline dialog
     */

    return Marionette.ItemView.extend({

        ui: {
            cancel: '.cancel',
            form: 'form',
            name: "input[name='name']"
        },

        // Delegate events
        events: {
            "submit @ui.form": "submit",
            'click @ui.cancel': 'cancel',
            'click': 'preventHide'
        },

        /**
         * hack: The only way to prevent hiding inline dialog when clicking it's contents
         * @param {Event} e
         */
        preventHide: function preventHide(e) {
            e.stopPropagation();
        },

        cancel: function cancel(e) {
            e.preventDefault();
            if (inlineDialog.current) {
                inlineDialog.current.hide();
            }
        },

        template: TemplateScreenEditor.addEditTabDialog,

        serializeData: function serializeData() {
            return {
                errorMessage: this._errorMessage,
                name: this._name,
                submitButtonText: this._submitButtonText
            };
        },

        /**
         * Handles form submission
         * @param {Event} e
         */
        submit: function submit(e) {
            e.preventDefault();
            var name = this.ui.name.val();
            this.submitDeferred(name).done(function () {
                if (inlineDialog.current) {
                    inlineDialog.current.hide();
                }
            }).fail(function (xhr) {
                var res = JSON.parse(xhr.responseText);
                if (res && res.errors && res.errors.name) {
                    // if there is something wrong with the name input. Display inline error.
                    this._errorMessage = res.errors.name;
                    this._name = name;

                    this.render();
                } else {
                    Utils.showErrorDialogForData(res);
                }

                logger.trace('tab.rename.complete');
            }.bind(this));
        },

        onRender: function onRender() {
            this.ui.name.focus();
        }
    });
});