define("jira-project-config/screen-editor/add-field-view", ['jira-project-config/marionette', 'jquery', 'wrm/context-path', 'jira/util/key-code', 'jira/ajs/select/single-select', 'jira-project-config/screen-editor/utils', 'jira-project-config/screen-editor/template'], function (Marionette, jQuery, wrmContextPath, keyCodes, SingleSelect, Utils, TemplateScreenEditor) {
    "use strict";

    return Marionette.ItemView.extend({

        template: TemplateScreenEditor.availableFields,

        serializeData: function serializeData() {
            return {
                fields: this.availableFields || []
            };
        },

        ui: {
            picker: "#field-picker",
            pickerField: '#field-picker-field',
            addFieldButton: '.add-field-button',
            form: 'form'
        },

        events: {
            'click @ui.addFieldButton': '_addField',
            'submit @ui.form': '_onSubmit',
            'change @ui.pickerField': '_validateForm',
            'change @ui.picker': '_validateForm',
            'keydown @ui.pickerField': '_fieldPickerKeyDown'
        },

        _addFieldUrl: function _addFieldUrl() {
            var projectKeyQuery = this._projectKey ? "?projectKey=" + encodeURI(this._projectKey) : "";

            return wrmContextPath() + "/rest/api/2/screens/" + this.model.get("id") + "/tabs/" + this._selectedTab + "/fields" + projectKeyQuery;
        },

        _onSubmit: function _onSubmit(e) {
            e.preventDefault();
        },

        _fieldPickerKeyDown: function _fieldPickerKeyDown(e) {
            if (e.keyCode === keyCodes.ENTER) {
                this._addField(e);
            }
        },

        _addField: function _addField(e) {
            e.preventDefault();

            if (!this._isFormValid()) {
                return;
            }

            var fieldId = this.ui.picker.val();
            this._ajaxCall = true;

            this._validateForm();

            jQuery.ajax({
                url: this._addFieldUrl(),
                type: "POST",
                contentType: "application/json",
                data: JSON.stringify({
                    fieldId: fieldId[0]
                })
            }).done(function (data) {
                this._table.addRow(data);
                this.fetchFieldsAndRerender();
            }.bind(this)).fail(function (xhr) {
                Utils.showErrorDialogForXhr(xhr);
            }).always(function () {
                this._ajaxCall = false;

                this._validateForm();
            }.bind(this));
        },

        _disableField: function _disableField(field) {
            field.attr('aria-disabled', true);
            field.attr('disabled', true);
        },

        _enableField: function _enableField(field) {
            field.removeAttr('aria-disabled');
            field.removeAttr('disabled');
        },

        _isFormValid: function _isFormValid() {
            return this.ui.picker.val() && this.ui.picker.val().length === 1 && !this._ajaxCall;
        },

        _validateForm: function _validateForm() {
            if (!this._isFormValid()) {
                this._disableField(this.ui.addFieldButton);
            } else {
                this._enableField(this.ui.addFieldButton);
            }

            if (this._ajaxCall || !this.availableFields) {
                this._disableField(this.ui.pickerField);
            } else {
                this._enableField(this.ui.pickerField);
            }
        },

        onRender: function onRender() {

            var singleSelect = new SingleSelect({
                element: this.ui.picker,
                setMaxHeightToWindow: true,
                itemAttrDisplayed: 'label'
            });

            singleSelect.showErrorMessage = jQuery.noop;
            this.bindUIElements();

            if (this.availableFields) {
                // Only focus this field if we add a field (not on tab load).
                if (!this.firstRender) {
                    singleSelect.$field.focus();
                }
                this.firstRender = false;
            }

            this._validateForm();
        },

        fetchFieldsAndRerender: function fetchFieldsAndRerender() {
            this.ui.addFieldButton.val("");
            this.model.getAvailableFields().done(function (availableFields) {
                this.availableFields = availableFields;
                this.render();
            }.bind(this));
        },

        initialize: function initialize(options) {
            this.firstRender = true;
            this._ajaxCall = false;

            this.model = options.model;
            this._table = options.table;
            this._selectedTab = options.selectedTab;
            this._projectKey = options._projectKey;
        }

    });
});