AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:project-config-roles"],function(){"use strict";var e=require("jira/util/formatter"),t=require("wrm/context-path"),a=require("jira-project-config/roles/entities/roles-results-model"),o=require("jira-project-config/roles/entities/role-collection"),i={projectKey:"?A&QUERY=1",roles:[{id:10001,name:"Administrators",total:4,groups:[{name:"jira-administrators"},{name:"jira-developers"}],users:[{active:!0,name:"sharwood",displayName:"Scott Harwood",email:"sh@gmail.com",applicationRoleNames:[]},{active:!0,name:"bbaker",displayName:"Brad Baker",email:"bb@gmail.com",applicationRoleNames:[]}]},{id:10002,name:"Customers",total:3,users:[{active:!0,name:"jwilson",displayName:"Julian Wilson",email:"sh@gmail.com",applicationRoleNames:[]},{active:!0,name:"kslater",displayName:"Kelly Slater",email:"kelly@gmail.com",applicationRoleNames:[]},{active:!0,name:"airons",displayName:"Andy Irons",email:"and@gmail.com",applicationRoleNames:[]}],groups:[]}]},s={roles:[{id:10001,name:"Administrators",total:0,groups:[],users:[]},{id:10002,name:"Customers",total:0,users:[],groups:[]}]},r={pageNumber:1,viewingRoleId:10001,roles:[{id:10001,name:"",total:192,groups:new Array(15),users:new Array(5)}]};module("jira-project-config/roles/entities/roles-results-model-test",{setup:function(){this.sandbox=sinon.sandbox.create(),this.sandbox.stub(e,"format",function(){return Array.prototype.slice.call(arguments,0).join(",")})},teardown:function(){this.sandbox.restore()}}),test("Model should have default values",function(){var e=new a;strictEqual(e.get("projectKey"),""),strictEqual(e.get("pageNumber"),1),strictEqual(e.get("viewingRoleId"),null),strictEqual(e.get("query"),""),deepEqual(e.get("roles").toJSON(),[])}),test("The old fetch request should be aborted before a new request is fired",function(){var e=new a,t=e.fetch(),o=this.sandbox.spy();t.fail(o);var i=e._currentFetchRequest;ok(i.abort(),!1),e.fetch(),ok(i.abort(),!0,"The old fetch request should be aborted"),sinon.assert.callCount(o,0,"Fail callback should not be called when the request is aborted.")}),test("toFilterRoleOptions",function(){var e=new a(i),t=e.toFilterRoleOptions();deepEqual(t,[{text:"common.words.all",value:""},{text:"Administrators",value:10001},{text:"Customers",value:10002}])}),test("toRoleOptions",function(){var e=new a(i),t=e.toRoleOptions();deepEqual(t,[{text:"Administrators",value:10001},{text:"Customers",value:10002}])}),test("Should use a nested roles collection when use set roles",function(){var e=new a(i);ok(e.get("roles")instanceof o,"Should use a nested roles collection when use set roles")}),test("isViewingDefaultView",function(){var e=new a(i);strictEqual(e.isViewingDefaultView(),!0),e.set("query","blah"),strictEqual(e.isViewingDefaultView(),!1),e.set("query",""),e.set("viewingRoleId",10002),strictEqual(e.isViewingDefaultView(),!1)}),test("isRoleResultEmpty",function(){var e=new a(i);strictEqual(e.isRoleResultEmpty(),!1),e=new a(s),strictEqual(e.isRoleResultEmpty(),!0)}),test("getVisibleActorsCount",function(){var e=new a(r);e.set("pageNumber",1),strictEqual(e.getVisibleActorsCount(),20)}),test("getTotalPageNumber",function(){var e=new a(r);strictEqual(e.getTotalPageNumber(),10,"Should return total page number when viewing a specific role"),e.set("viewingRoleId",null),strictEqual(e.getTotalPageNumber(),void 0,"Should return undefined when viewing all roles")}),test("Fetcher URL Should be encoded",function(){var e=new a(i);e.set("query","&tim=&amp;&no"),strictEqual(e.url(),t()+"/rest/projectconfig/latest/roles/%3FA&QUERY=1?query="+encodeURIComponent("&tim=&amp;&no")+"&pageNumber=1&pageSize=5","URL should encoded"),e.set("viewingRoleId",10009),strictEqual(e.url(),t()+"/rest/projectconfig/latest/roles/%3FA&QUERY=1?query="+encodeURIComponent("&tim=&amp;&no")+"&pageNumber=1&pageSize=20&roleId=10009","URL should encoded")}),test("_buildPaginationData",function(){var e=new a(r);e.set("pageNumber",1),deepEqual(e._buildPaginationData(),{firstPage:null,previousPage:null,pages:[{number:1,selected:!0},{number:2,selected:!1},{number:3,selected:!1}],nextPage:2,lastPage:10,showingFrom:1,showingTo:20}),e.set("pageNumber",2),deepEqual(e._buildPaginationData(),{firstPage:1,previousPage:1,pages:[{number:1,selected:!1},{number:2,selected:!0},{number:3,selected:!1},{number:4,selected:!1}],nextPage:3,lastPage:10,showingFrom:21,showingTo:40}),e.set("pageNumber",4),deepEqual(e._buildPaginationData(),{firstPage:1,previousPage:3,pages:[{number:2,selected:!1},{number:3,selected:!1},{number:4,selected:!0},{number:5,selected:!1},{number:6,selected:!1}],nextPage:5,lastPage:10,showingFrom:61,showingTo:80}),e.set("pageNumber",9),deepEqual(e._buildPaginationData(),{firstPage:1,previousPage:8,pages:[{number:7,selected:!1},{number:8,selected:!1},{number:9,selected:!0},{number:10,selected:!1}],nextPage:10,lastPage:10,showingFrom:161,showingTo:180}),e.set("pageNumber",10),deepEqual(e._buildPaginationData(),{firstPage:1,previousPage:9,pages:[{number:8,selected:!1},{number:9,selected:!1},{number:10,selected:!0}],nextPage:null,lastPage:null,showingFrom:181,showingTo:192})}),test("toJSON with extra infomation",function(){var e=new a(i);e.set({query:"&tim=&amp;&no",viewingRoleId:10002});var t=e.toJSON();strictEqual(t.isViewingDefaultView,!1),strictEqual(t.isRoleResultEmpty,!1),strictEqual(t.allRoleViewPageSize,5),strictEqual(t.totalPageNumber,1),ok(void 0!==t.paginationData)}),test("_getPageSize",function(){var e=new a({viewingRoleId:null});strictEqual(e._getPageSize(),5,"Should have page size of 5 when viewing all roles"),e.set("viewingRoleId",10009),strictEqual(e._getPageSize(),20,"Should have page size of 20 when viewing a specific role")}),test("Fetch URL should be correct with or without contextPath",function(){var e=this.stub(),t=AJS.test.mockableModuleContext();t.mock("wrm/context-path",e);var a=t.require("jira-project-config/roles/entities/roles-results-model"),o=new a(i);o.set("query","&tim=&amp;&no"),e.returns("/jira"),ok(0===o.url().indexOf("/jira/rest/projectconfig/latest/roles/%3FA&QUERY=1?query="),"Fetch URL should be correct with context path"),e.returns(""),ok(0===o.url().indexOf("/rest/projectconfig/latest/roles/%3FA&QUERY=1?query="),"Fetch URL should be correct without context path")})});