define("jira-project-config/permissions/js/permissions-table", ['jira-project-config/permissions/js/permissions-data', 'jira/project/permissions/permissionschememodel', 'jira/project/permissions/permissiongroupview', 'jira/project/permissions/permissioncollection', 'jira/util/logger', 'underscore'], function (permissionData, PermissionSchemeModel, PermissionsGroupView, ProjectPermissionCollection, logger, _) {
    "use strict";

    /**
     * Provides methods for "jira-permissions-table" skate component
     */

    return {
        attached: function attached(element) {
            if (typeof permissionData.id === "undefined") {
                logger.error("Could not get getPermissionSchemeModelData");
                return;
            }

            var data = {
                id: permissionData.id,
                name: permissionData.name,
                description: permissionData.description,
                displayRendering: permissionData.displayRendering,
                permissions: new ProjectPermissionCollection(permissionData.permissions),
                readOnly: element.getAttribute('aria-readonly') === 'true'
            };

            var permissionSchemeModel = new PermissionSchemeModel(data);

            var grouping = permissionSchemeModel.get("displayRendering").grouping;
            var isReadOnly = permissionSchemeModel.isReadOnly();

            _.each(grouping, function (group) {
                var groupModel = permissionSchemeModel.getGroupModel(group);
                var groupView = new PermissionsGroupView({ model: groupModel, readOnly: isReadOnly });
                element.appendChild(groupView.render().el);
            });
        }
    };
});