AJS.test.require(["com.atlassian.jira.jira-project-config-plugin:permissions-table"], function () {
    "use strict";

    var DATA_KEY = "com.atlassian.jira.jira-project-config-plugin:permissions-data.permissionSchemeModel";
    var PERMISSIONS_DATA = Object.freeze({
        "id": 0,
        "name": "Default Permission Scheme",
        "description": "This is the default Permission Scheme",
        "permissions": [],
        "displayRendering": {},
        "operationResult": null
    });

    var jQuery = require("jquery");
    var wrmData = require("wrm/data");
    var logger = require("jira/util/logger");

    module("JIRA.Permissions.Table", {
        setup: function setup() {
            var sandbox = this.sandbox = sinon.sandbox.create();
            var context = this.context = AJS.test.mockableModuleContext();

            this.$element = jQuery('<div aria-readonly="true"></div>');
            jQuery("#qunit-fixture").append(this.$element);

            this.PermissionSchemeModel = sandbox.spy(require("jira/project/permissions/permissionschememodel"));
            context.mock("jira/project/permissions/permissionschememodel", this.PermissionSchemeModel);

            this.PermissionGroupView = sinon.spy(require("jira/project/permissions/permissiongroupview"));
            context.mock("jira/project/permissions/permissiongroupview", this.PermissionGroupView);

            this.PermissionCollection = sinon.spy(require("jira/project/permissions/permissioncollection"));
            context.mock("jira/project/permissions/permissioncollection", this.PermissionCollection);

            sandbox.spy(logger, "error");
            context.mock("jira/util/logger", logger);
        },
        teardown: function teardown() {
            this.sandbox.restore();
        },
        mockWRMData: function mockWRMData(permissionsData) {
            this.sandbox.stub(wrmData, "claim");
            wrmData.claim.withArgs(DATA_KEY).returns(permissionsData);
            this.context.mock("wrm/data", wrmData);

            this.permissionData = this.context.require("jira-project-config/permissions/js/permissions-data");
            this.context.mock("jira-project-config/permissions/js/permissions-data", this.permissionData);
        },
        createTable: function createTable() {
            this.context.require("jira-project-config/permissions/js/permissions-table").attached(this.$element.get(0));
        }
    });

    test("Should use proper WRM data key", function () {
        this.mockWRMData(PERMISSIONS_DATA);
        this.createTable();

        sinon.assert.notCalled(logger.error);
        sinon.assert.calledOnce(this.PermissionSchemeModel);
    });

    test("Should construct proper object for PermissionSchemeModel", function () {
        this.mockWRMData(PERMISSIONS_DATA);
        this.createTable();

        sinon.assert.calledWith(this.PermissionSchemeModel, sinon.match.has("id", sinon.match.number).and(sinon.match.has("name", sinon.match.string)).and(sinon.match.has("description", sinon.match.string)).and(sinon.match.has("displayRendering", sinon.match.object)).and(sinon.match.has("permissions", sinon.match.object)).and(sinon.match.has("readOnly", true)));
    });

    test("Should return fast when WRM data is null", function () {
        this.mockWRMData(null);
        this.createTable();

        sinon.assert.calledOnce(logger.error);
        sinon.assert.notCalled(this.PermissionSchemeModel);
    });
});